/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.waypoints;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class WaypointManager {
    private SurvivalEnhanced plugin;
    private FileConfiguration waypointsConfig;
    private Map<Player, String> playerToWaypointNavigating = Map.of();

    public WaypointManager(SurvivalEnhanced plugin) {
        this.plugin = plugin;
        this.waypointsConfig = plugin.getWaypointsConfig();
        this.startNavigationLoop();
    }

    private void startNavigationLoop() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.playerToWaypointNavigating.forEach((player, name) -> {
            if (this.getAllWaypoints((Player)player).contains(name)) {
                if (this.nearbyLocations(player.getLocation(), this.getWaypoint((Player)player, (String)name))) {
                    player.sendActionBar((Component)Component.text((String)"\u00a7aYou reached your destination."));
                    player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    this.stopNavigation((Player)player);
                }
                this.showParticles((Player)player, this.getWaypoint((Player)player, (String)name));
                this.spawnWaypointCircle((Player)player, this.getWaypoint((Player)player, (String)name));
            }
        }), 0L, 20L);
    }

    private boolean nearbyLocations(Location loc1, Location loc2) {
        if (loc1.getWorld() == null || !loc1.getWorld().equals((Object)loc2.getWorld())) {
            return false;
        }
        return loc1.distance(loc2) <= 2.0;
    }

    private void showParticles(Player player, Location waypoint) {
        Location start = player.getEyeLocation().clone().subtract(0.0, 0.6, 0.0);
        Location end = waypoint.clone().add(0.0, 1.0, 0.0);
        Vector direction = end.toVector().subtract(start.toVector()).normalize();
        double maxDistance = 4.0;
        double step = 0.3;
        int particleCount = (int)(maxDistance / step);
        for (int i = 1; i <= particleCount; ++i) {
            Location point = start.clone().add(direction.clone().multiply((double)i * step));
            player.spawnParticle(Particle.END_ROD, point, 1, 0.0, 0.0, 0.0, 0.0);
        }
        double distance = (double)Math.round(player.getLocation().distance(waypoint) * 100.0) / 100.0;
        player.sendActionBar((Component)Component.text((String)("\u00a7a" + distance + " blocks away.")));
    }

    private void spawnWaypointCircle(Player player, Location center) {
        if (player.getLocation().distance(center) > 50.0) {
            return;
        }
        Location base = center.clone().add(0.5, 0.1, 0.5);
        double radius = 0.7;
        int points = 24;
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            Location particleLoc = base.clone().add(x, 0.0, z);
            player.spawnParticle(Particle.END_ROD, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public Map<Player, String> getPlayerToWaypointNavigating() {
        return this.playerToWaypointNavigating;
    }

    public void startNavigation(Player player, String name) {
        HashMap<Player, String> newMap = new HashMap<Player, String>();
        newMap.putAll(this.playerToWaypointNavigating);
        newMap.put(player, name);
        this.playerToWaypointNavigating = newMap;
    }

    public void stopNavigation(Player player) {
        HashMap<Player, String> newMap = new HashMap<Player, String>();
        newMap.putAll(this.playerToWaypointNavigating);
        newMap.remove(player);
        this.playerToWaypointNavigating = newMap;
    }

    public void removeWaypoint(Player player, String name) {
        this.waypointsConfig.set(player.getUniqueId().toString() + "." + name, null);
        this.stopNavigation(player);
        try {
            this.waypointsConfig.save(this.plugin.getWaypointsFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openSubMenu(Player player) {
        Inventory inventory = this.plugin.getServer().createInventory(null, 9, (Component)Component.text((String)"\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints"));
        ItemStack addWaypointItem = new ItemStack(Material.OAK_SIGN);
        ItemMeta addWaypointItemMeta = addWaypointItem.getItemMeta();
        addWaypointItemMeta.displayName((Component)Component.text((String)"\u00a7aAdd Waypoint"));
        addWaypointItem.setItemMeta(addWaypointItemMeta);
        inventory.setItem(0, addWaypointItem);
        ItemStack removeWaypointItem = new ItemStack(Material.BARRIER);
        ItemMeta removeWaypointItemMeta = removeWaypointItem.getItemMeta();
        removeWaypointItemMeta.displayName((Component)Component.text((String)"\u00a7cRemove Waypoint"));
        removeWaypointItem.setItemMeta(removeWaypointItemMeta);
        inventory.setItem(1, removeWaypointItem);
        ItemStack navigateWaypointItem = new ItemStack(Material.COMPASS);
        ItemMeta navigateWaypointItemMeta = navigateWaypointItem.getItemMeta();
        navigateWaypointItemMeta.displayName((Component)Component.text((String)"\u00a7aNavigate to Waypoint"));
        navigateWaypointItem.setItemMeta(navigateWaypointItemMeta);
        inventory.setItem(2, navigateWaypointItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backItemMeta = backItem.getItemMeta();
        backItemMeta.displayName((Component)Component.text((String)"\u00a7cBack"));
        backItem.setItemMeta(backItemMeta);
        inventory.setItem(8, backItem);
        player.openInventory(inventory);
    }

    public void openWaypointMenu(Player player) {
        if (!this.plugin.getFunctionManager().isFunctionEnabled(Function.WAYPOINTS)) {
            return;
        }
        Inventory inventory = this.plugin.getServer().createInventory(null, 9, (Component)Component.text((String)"\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Navigate"));
        for (String waypointName : this.getAllWaypoints(player)) {
            inventory.addItem(new ItemStack[]{this.createWaypointsItem(player, waypointName)});
        }
        ItemStack stopNavigationItem = new ItemStack(Material.BARRIER);
        ItemMeta stopNavigationItemMeta = stopNavigationItem.getItemMeta();
        stopNavigationItemMeta.displayName((Component)Component.text((String)"\u00a7cStop Navigation"));
        stopNavigationItem.setItemMeta(stopNavigationItemMeta);
        inventory.setItem(8, stopNavigationItem);
        player.openInventory(inventory);
    }

    private Double roundToTwoDecimals(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    private ItemStack createWaypointsItem(Player player, String waypointName) {
        ItemStack itemStack = new ItemStack(Material.NAME_TAG);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.displayName((Component)Component.text((String)("\u00a7a" + waypointName)));
        itemMeta.lore(List.of(Component.text((String)("\u00a77" + Math.round(this.getWaypoint(player, waypointName).distance(player.getLocation())) + " \u00a77blocks away"))));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public List<String> getAllWaypoints(Player player) {
        ConfigurationSection configurationSection = this.waypointsConfig.getConfigurationSection(player.getUniqueId().toString());
        if (configurationSection == null) {
            return new ArrayList<String>();
        }
        Set keys = configurationSection.getKeys(false);
        return keys.stream().toList();
    }

    public Location getWaypoint(Player player, String name) {
        if (!this.waypointsConfig.contains(player.getUniqueId().toString() + "." + name)) {
            return null;
        }
        double x = this.waypointsConfig.getDouble(player.getUniqueId().toString() + "." + name + ".x");
        double y = this.waypointsConfig.getDouble(player.getUniqueId().toString() + "." + name + ".y");
        double z = this.waypointsConfig.getDouble(player.getUniqueId().toString() + "." + name + ".z");
        float yaw = (float)this.waypointsConfig.getDouble(player.getUniqueId().toString() + "." + name + ".yaw");
        float pitch = (float)this.waypointsConfig.getDouble(player.getUniqueId().toString() + "." + name + ".pitch");
        return new Location(player.getWorld(), x, y, z, yaw, pitch);
    }

    public void addWaypoint(Player player, String name, Location location) {
        this.waypointsConfig.set(player.getUniqueId().toString() + "." + name + ".x", (Object)location.getX());
        this.waypointsConfig.set(player.getUniqueId().toString() + "." + name + ".y", (Object)location.getY());
        this.waypointsConfig.set(player.getUniqueId().toString() + "." + name + ".z", (Object)location.getZ());
        this.waypointsConfig.set(player.getUniqueId().toString() + "." + name + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.waypointsConfig.set(player.getUniqueId().toString() + "." + name + ".pitch", (Object)Float.valueOf(location.getPitch()));
        try {
            this.waypointsConfig.save(this.plugin.getWaypointsFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

