/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.waypoints;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.waypoints.WaypointManager;
import io.papermc.paper.event.player.ChatEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WaypointInventoryClickListener
implements Listener {
    private SurvivalEnhanced plugin;
    private List<Player> playersToCatchMessage;

    public WaypointInventoryClickListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
        this.playersToCatchMessage = new ArrayList<Player>();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = LegacyComponentSerializer.legacySection().serialize(event.getView().title());
        if (title.equals("\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Navigate")) {
            if (event.getCurrentItem() == null) {
                return;
            }
            if (!event.getCurrentItem().hasItemMeta() || !event.getCurrentItem().getItemMeta().hasDisplayName()) {
                return;
            }
            String displayName = LegacyComponentSerializer.legacySection().serialize(Objects.requireNonNull(event.getCurrentItem().getItemMeta().displayName()));
            if (displayName == null) {
                return;
            }
            WaypointManager waypointManager = this.plugin.getWaypointManager();
            if (displayName.equals("\u00a7cStop Navigation")) {
                waypointManager.stopNavigation((Player)event.getWhoClicked());
                event.setCancelled(true);
                event.getInventory().close();
                event.getWhoClicked().sendActionBar((Component)Component.text((String)"\u00a7cStopped Navigation"));
                return;
            }
            String waypointName = displayName.substring(2);
            Location waypoint = waypointManager.getWaypoint((Player)event.getWhoClicked(), waypointName);
            if (waypoint == null) {
                return;
            }
            waypointManager.startNavigation((Player)event.getWhoClicked(), waypointName);
            event.setCancelled(true);
            event.getInventory().close();
            event.getWhoClicked().sendActionBar((Component)Component.text((String)("\u00a7aNavigating to " + waypointName)));
        } else if (title.equals("\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints")) {
            if (event.getCurrentItem() == null) {
                return;
            }
            if (!event.getCurrentItem().hasItemMeta() || !event.getCurrentItem().getItemMeta().hasDisplayName()) {
                return;
            }
            String displayName = LegacyComponentSerializer.legacySection().serialize(Objects.requireNonNull(event.getCurrentItem().getItemMeta().displayName()));
            if (displayName == null) {
                return;
            }
            if (displayName.equals("\u00a7aAdd Waypoint")) {
                event.setCancelled(true);
                event.getInventory().close();
                this.handleAddWaypointClick(event, this.plugin);
            } else if (displayName.equals("\u00a7cRemove Waypoint")) {
                event.setCancelled(true);
                event.getInventory().close();
                this.handleRemoveWaypointClick(event, this.plugin);
            } else if (displayName.equals("\u00a7aNavigate to Waypoint")) {
                this.plugin.getWaypointManager().openWaypointMenu((Player)event.getWhoClicked());
            } else if (displayName.equals("\u00a7cBack")) {
                event.setCancelled(true);
                event.getInventory().close();
                this.plugin.getPlayerMenuManager().openPlayerMenu((Player)event.getWhoClicked());
            }
        } else if (title.equals("\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Add")) {
            if (event.getCurrentItem().getType() == Material.PAPER) {
                String displayName = LegacyComponentSerializer.legacySection().serialize(Objects.requireNonNull(event.getCurrentItem().getItemMeta().displayName()));
                String name = displayName.replace("\u00a7aEnter waypoint name:", "");
                if (name.isEmpty()) {
                    event.getInventory().close();
                    event.getWhoClicked().sendActionBar((Component)Component.text((String)"\u00a7cName cannot be empty"));
                    return;
                }
                this.plugin.getWaypointManager().addWaypoint((Player)event.getWhoClicked(), name, event.getWhoClicked().getLocation());
                event.getInventory().close();
                event.getWhoClicked().sendActionBar((Component)Component.text((String)"\u00a7aAdded Waypoint"));
                event.setCancelled(true);
            }
        } else if (title.equals("\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Remove")) {
            if (event.getCurrentItem().getType() == Material.PAPER) {
                String displayName = LegacyComponentSerializer.legacySection().serialize(Objects.requireNonNull(event.getCurrentItem().getItemMeta().displayName()));
                String name = displayName.substring(2);
                this.plugin.getWaypointManager().removeWaypoint((Player)event.getWhoClicked(), name);
                event.getInventory().close();
                event.getWhoClicked().sendActionBar((Component)Component.text((String)"\u00a7aRemoved Waypoint"));
                event.setCancelled(true);
            } else if (event.getCurrentItem().getType() == Material.ARROW) {
                Component component = event.getCurrentItem().getItemMeta().displayName();
                String displayName = LegacyComponentSerializer.legacySection().serialize(Objects.requireNonNull(component));
                if (displayName.equals("\u00a7cBack")) {
                    event.setCancelled(true);
                    event.getInventory().close();
                    this.plugin.getWaypointManager().openSubMenu((Player)event.getWhoClicked());
                }
            }
        }
    }

    public void handleRemoveWaypointClick(InventoryClickEvent event, SurvivalEnhanced plugin) {
        Inventory inventoryToOpen = plugin.getServer().createInventory(null, 9, "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Remove");
        for (String s : plugin.getWaypointManager().getAllWaypoints((Player)event.getWhoClicked())) {
            ItemStack itemToAdd = new ItemStack(Material.PAPER);
            ItemMeta itemMeta = itemToAdd.getItemMeta();
            itemMeta.displayName((Component)Component.text((String)("\u00a7a" + s)));
            itemToAdd.setItemMeta(itemMeta);
            inventoryToOpen.addItem(new ItemStack[]{itemToAdd});
        }
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backItemMeta = backItem.getItemMeta();
        backItemMeta.displayName((Component)Component.text((String)"\u00a7cBack"));
        backItem.setItemMeta(backItemMeta);
        inventoryToOpen.setItem(8, backItem);
        event.getWhoClicked().openInventory(inventoryToOpen);
    }

    public void handleAddWaypointClick(InventoryClickEvent event, SurvivalEnhanced plugin) {
        String displayName = event.getCurrentItem() != null && event.getCurrentItem().getItemMeta() != null ? event.getCurrentItem().getItemMeta().getDisplayName() : "";
        Player player = (Player)event.getWhoClicked();
        player.sendMessage((Component)Component.text((String)"\u00a7eType your waypoint name in the chat or type \"cancel\" to cancel."));
        this.playersToCatchMessage.add(player);
    }

    @EventHandler
    public void onChat(ChatEvent event) {
        Player player = event.getPlayer();
        Component message = event.message();
        String readableMessage = LegacyComponentSerializer.legacySection().serialize(Objects.requireNonNull(message));
        if (readableMessage.isEmpty()) {
            return;
        }
        if (this.playersToCatchMessage.contains(player)) {
            if (readableMessage.equals("cancel")) {
                player.sendMessage((Component)Component.text((String)"\u00a7ccancelled waypoint creation."));
                event.setCancelled(true);
                return;
            }
            this.playersToCatchMessage.remove(player);
            this.plugin.getWaypointManager().addWaypoint(player, readableMessage, player.getLocation());
            player.closeInventory();
            player.sendActionBar((Component)Component.text((String)"\u00a7aAdded Waypoint"));
            event.setCancelled(true);
            player.sendMessage((Component)Component.text((String)("\u00a7aWaypoint " + readableMessage + " added.")));
        }
    }
}

