/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.playermenu;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class InventoryClickListener
implements Listener {
    private SurvivalEnhanced plugin;

    public InventoryClickListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = LegacyComponentSerializer.legacySection().serialize(event.getView().title());
        if (title.equals("\u00a7cSurvival\u00a7eEnhanced \u00a77Menu")) {
            String name;
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                this.plugin.getLogger().info("Invalid item clicked: " + String.valueOf(event.getCurrentItem()));
                return;
            }
            if (!event.getCurrentItem().hasItemMeta() || !event.getCurrentItem().getItemMeta().hasDisplayName()) {
                this.plugin.getLogger().info("Invalid item clicked: " + String.valueOf(event.getCurrentItem()));
                return;
            }
            Component displayName = event.getCurrentItem().getItemMeta().displayName();
            if (displayName == null) {
                this.plugin.getLogger().info("Invalid item clicked: " + String.valueOf(displayName));
                return;
            }
            switch (name = LegacyComponentSerializer.legacySection().serialize(displayName)) {
                case "\u00a7aToggle Torch Placer": {
                    this.plugin.getAutomaticTorchPlacerManager().toggleTorchPlacer((Player)event.getWhoClicked());
                    this.plugin.getLogger().info("Toggled Torch Placer for " + ((Player)event.getWhoClicked()).getName());
                    break;
                }
                case "\u00a7aWaypoints": {
                    this.plugin.getWaypointManager().openSubMenu((Player)event.getWhoClicked());
                    this.plugin.getLogger().info("Opened Waypoint Menu for " + ((Player)event.getWhoClicked()).getName());
                    break;
                }
                case "\u00a7aAuto Replant Crops": {
                    this.plugin.getCropListener().togglePlayer((Player)event.getWhoClicked());
                }
            }
        }
    }
}

