/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.functionManager;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.logging.Logger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class InventoryClickListener
implements Listener {
    private SurvivalEnhanced plugin;

    public InventoryClickListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = LegacyComponentSerializer.legacySection().serialize(event.getView().title());
        if (title.equals("\u00a7cSurvival\u00a7eEnhanced \u00a77Functions")) {
            if (event.getCurrentItem() == null) {
                return;
            }
            if (!event.getCurrentItem().hasItemMeta() || !event.getCurrentItem().getItemMeta().hasDisplayName()) {
                return;
            }
            Logger logger = this.plugin.getLogger();
            String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
            HumanEntity entity = event.getWhoClicked();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            switch (displayName) {
                case "\u00a7aAnvil Level Limiter": {
                    this.toggleFunction(player, Function.ANVIL_LEVEL_LIMITER);
                    break;
                }
                case "\u00a7aKeep Workbench Items": {
                    this.toggleFunction(player, Function.KEEP_WORKBENCH_ITEMS);
                    break;
                }
                case "\u00a7aCompact Bonemeal": {
                    this.toggleFunction(player, Function.COMPACT_BONEMEAL);
                    break;
                }
                case "\u00a7aAuto Open Connected Doors": {
                    this.toggleFunction(player, Function.AUTO_OPEN_CONNECTED_DOORS);
                    break;
                }
                case "\u00a7aAuto Replace Saplings": {
                    this.toggleFunction(player, Function.AUTO_REPLACE_SAPLING);
                    break;
                }
                case "\u00a7aAuto Torch Placer": {
                    this.toggleFunction(player, Function.AUTO_TORCH_PLACER);
                    break;
                }
                case "\u00a7aWaypoints": {
                    this.toggleFunction(player, Function.WAYPOINTS);
                    break;
                }
                case "\u00a7aBetter Sleep": {
                    this.toggleFunction(player, Function.BETTER_SLEEP);
                    break;
                }
                case "\u00a7aAuto Replant Crops": {
                    this.toggleFunction(player, Function.AUTO_REPLANT_CROPS);
                    break;
                }
                case "\u00a7aBreadcrumb Trails": {
                    this.toggleFunction(player, Function.BREADCRUMB);
                }
            }
            event.setCancelled(true);
            this.reopenInventory(event);
        }
    }

    private void toggleFunction(Player player, Function function) {
        if (this.plugin.getFunctionManager().isFunctionEnabled(function)) {
            this.plugin.getFunctionManager().disableFunction(function);
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_OFF, 1.0f, 1.0f);
        } else {
            this.plugin.getFunctionManager().enableFunction(function);
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
        }
    }

    private void reopenInventory(InventoryClickEvent event) {
        event.getWhoClicked().closeInventory();
        event.getWhoClicked().openInventory(this.plugin.getFunctionManager().createFunctionManagerInventory());
    }
}

