/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.betterSleepSystem;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;

public class PlayerSleepListener
implements Listener {
    private SurvivalEnhanced plugin;
    List<Player> asleepPlayers = new ArrayList<Player>();

    public PlayerSleepListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoinSleep(PlayerBedEnterEvent event) {
        if (!this.plugin.getFunctionManager().isFunctionEnabled(Function.BETTER_SLEEP)) {
            return;
        }
        if (this.plugin.getServer().getOnlinePlayers().size() < 2) {
            return;
        }
        Player player = event.getPlayer();
        this.asleepPlayers.add(player);
        int minAsleepPlayers = this.plugin.getServer().getOnlinePlayers().size() / 2;
        if (minAsleepPlayers <= this.asleepPlayers.size()) {
            if (event.getPlayer().getWorld().isClearWeather()) {
                event.getPlayer().getWorld().setTime(1000L);
            } else {
                World world = event.getPlayer().getWorld();
                world.setStorm(false);
                world.setThundering(false);
                world.setWeatherDuration(0);
                world.setThunderDuration(0);
            }
        }
    }

    @EventHandler
    public void onPlayerLeaveSleep(PlayerBedLeaveEvent event) {
        this.asleepPlayers.remove(event.getPlayer());
        int minAsleepPlayers = this.plugin.getServer().getOnlinePlayers().size() / 2;
        if (minAsleepPlayers <= this.asleepPlayers.size()) {
            if (event.getPlayer().getWorld().isClearWeather()) {
                event.getPlayer().getWorld().setTime(1000L);
            } else {
                World world = event.getPlayer().getWorld();
                world.setStorm(false);
                world.setThundering(false);
                world.setWeatherDuration(0);
                world.setThunderDuration(0);
            }
        }
    }
}

