/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.autoReplantCrops;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockBreakListener
implements Listener {
    private SurvivalEnhanced plugin;
    private List<Player> activePlayers = new ArrayList<Player>();

    public void togglePlayer(Player player) {
        if (this.activePlayers.contains(player)) {
            this.activePlayers.remove(player);
            player.sendActionBar(Component.text((String)"Replant crops disabled").color(TextColor.color((int)200, (int)92, (int)85)));
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_OFF, 1.0f, 1.0f);
        } else {
            this.activePlayers.add(player);
            player.sendActionBar(Component.text((String)"Replant crops enabled").color(TextColor.color((int)74, (int)200, (int)101)));
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
        }
    }

    public BlockBreakListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Ageable ageable;
        if (!this.plugin.getFunctionManager().isFunctionEnabled(Function.AUTO_REPLANT_CROPS)) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material blockType = block.getType();
        if (!this.activePlayers.contains(player)) {
            return;
        }
        HashMap<Material, Material> cropToSeed = new HashMap<Material, Material>();
        cropToSeed.put(Material.WHEAT, Material.WHEAT_SEEDS);
        cropToSeed.put(Material.BEETROOTS, Material.BEETROOT_SEEDS);
        cropToSeed.put(Material.CARROTS, Material.CARROT);
        cropToSeed.put(Material.POTATOES, Material.POTATO);
        cropToSeed.put(Material.NETHER_WART, Material.NETHER_WART);
        cropToSeed.put(Material.PITCHER_CROP, Material.PITCHER_POD);
        cropToSeed.put(Material.TORCHFLOWER_CROP, Material.TORCHFLOWER_SEEDS);
        if (!cropToSeed.containsKey(blockType)) {
            return;
        }
        Material seed = (Material)cropToSeed.get(blockType);
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable && (ageable = (Ageable)blockData).getAge() == ageable.getMaximumAge() && player.getInventory().containsAtLeast(new ItemStack(seed), 1)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                block.setType(blockType);
                BlockData newData = block.getBlockData();
                if (newData instanceof Ageable) {
                    Ageable newAgeable = (Ageable)newData;
                    newAgeable.setAge(0);
                    block.setBlockData((BlockData)newAgeable);
                }
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(seed, 1)});
            }, 1L);
        }
    }
}

