/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.autoReplaceSaplings;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.Arrays;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public class BlockBreakListener
implements Listener {
    private SurvivalEnhanced plugin;

    public BlockBreakListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Logger logger = this.plugin.getLogger();
        if (this.plugin.getFunctionManager().isFunctionEnabled(Function.AUTO_REPLACE_SAPLING)) {
            PlayerInventory inventory = event.getPlayer().getInventory();
            Block blockBelow = this.getBlockBelow(event.getBlock());
            Block blockTwoBelow = this.getBlockBelow(blockBelow);
            switch (event.getBlock().getType()) {
                case ACACIA_LOG: {
                    this.handleReplace(Material.ACACIA_SAPLING, Material.ACACIA_LOG, event);
                    break;
                }
                case DARK_OAK_LOG: {
                    this.handleReplace(Material.DARK_OAK_SAPLING, Material.DARK_OAK_LOG, event);
                    break;
                }
                case JUNGLE_LOG: {
                    this.handleReplace(Material.JUNGLE_SAPLING, Material.JUNGLE_LOG, event);
                    break;
                }
                case OAK_LOG: {
                    this.handleReplace(Material.OAK_SAPLING, Material.OAK_LOG, event);
                    break;
                }
                case SPRUCE_LOG: {
                    this.handleReplace(Material.SPRUCE_SAPLING, Material.SPRUCE_LOG, event);
                    break;
                }
                case PALE_OAK_LOG: {
                    this.handleReplace(Material.PALE_OAK_SAPLING, Material.PALE_OAK_LOG, event);
                    break;
                }
                case BIRCH_LOG: {
                    this.handleReplace(Material.BIRCH_SAPLING, Material.BIRCH_LOG, event);
                    break;
                }
                case CHERRY_LOG: {
                    this.handleReplace(Material.CHERRY_SAPLING, Material.CHERRY_LOG, event);
                }
            }
        }
    }

    private void removeItemOutOfInventory(Material material, PlayerInventory inventory) {
        @Nullable ItemStack[] inventoryContents = inventory.getContents();
        if (inventoryContents != null) {
            for (int i = 0; i < inventoryContents.length; ++i) {
                if (inventoryContents[i] == null || inventoryContents[i].getType() != material) continue;
                inventoryContents[i].setAmount(inventoryContents[i].getAmount() - 1);
            }
        }
    }

    private void handleReplace(Material sapling, Material log, BlockBreakEvent event) {
        PlayerInventory inventory = event.getPlayer().getInventory();
        Block blockBelow = this.getBlockBelow(event.getBlock());
        Block blockTwoBelow = blockBelow.getRelative(BlockFace.DOWN);
        if (Arrays.stream(inventory.getContents()).anyMatch(x -> x != null && x.getType() == sapling) && this.getBlockBelow(event.getBlock()).getType() == Material.AIR && (blockTwoBelow.getType() == Material.GRASS_BLOCK || blockTwoBelow.getType() == Material.DIRT)) {
            blockBelow.setType(sapling);
            this.removeItemOutOfInventory(sapling, inventory);
        }
    }

    private Block getBlockBelow(Block block) {
        return block.getRelative(BlockFace.DOWN);
    }
}

