/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.autoOpenConnectedDoors;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;

public class DoorOpenListener
implements Listener {
    private final SurvivalEnhanced plugin;
    private final List<Material> DOOR_MATERIALS = List.of(Material.ACACIA_DOOR, Material.BIRCH_DOOR, Material.DARK_OAK_DOOR, Material.JUNGLE_DOOR, Material.OAK_DOOR, Material.SPRUCE_DOOR, Material.BAMBOO_DOOR, Material.CRIMSON_DOOR, Material.WARPED_DOOR, Material.COPPER_DOOR, Material.MANGROVE_DOOR, Material.CHERRY_DOOR, Material.PALE_OAK_DOOR);

    public DoorOpenListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDoorOpen(PlayerInteractEvent event) {
        if (event.getAction().isLeftClick()) {
            return;
        }
        if (!this.plugin.getFunctionManager().isFunctionEnabled(Function.AUTO_OPEN_CONNECTED_DOORS)) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (!this.DOOR_MATERIALS.contains(clickedBlock.getType())) {
            return;
        }
        Logger logger = this.plugin.getLogger();
        BlockData clickedState = clickedBlock.getBlockData();
        if (!(clickedState instanceof Openable)) {
            return;
        }
        Openable clickedOpenable = (Openable)clickedState;
        boolean shouldOpen = !clickedOpenable.isOpen();
        List<Block> connectedBlocks = this.getConnectedOpenableBlocks(clickedBlock);
        connectedBlocks.add(clickedBlock);
        for (Block b : connectedBlocks) {
            BlockState state;
            BlockData blockData;
            if (!this.DOOR_MATERIALS.contains(b.getType()) || !((blockData = (state = b.getState()).getBlockData()) instanceof Openable)) continue;
            Openable openable = (Openable)blockData;
            openable.setOpen(shouldOpen);
            state.setBlockData((BlockData)openable);
            state.update(true, true);
        }
    }

    private List<Block> getConnectedOpenableBlocks(Block clickedBlock) {
        ArrayList<Block> connectedBlocks = new ArrayList<Block>();
        int x = clickedBlock.getX();
        int y = clickedBlock.getY();
        int z = clickedBlock.getZ();
        World world = clickedBlock.getWorld();
        connectedBlocks.add(world.getBlockAt(x + 1, y, z));
        connectedBlocks.add(world.getBlockAt(x - 1, y, z));
        connectedBlocks.add(world.getBlockAt(x, y + 1, z));
        connectedBlocks.add(world.getBlockAt(x, y - 1, z));
        connectedBlocks.add(world.getBlockAt(x, y, z + 1));
        connectedBlocks.add(world.getBlockAt(x, y, z - 1));
        return connectedBlocks.stream().filter(b -> this.DOOR_MATERIALS.contains(b.getType())).collect(Collectors.toList());
    }
}

