/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.waypoints;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class WaypointManager {
    private final SurvivalEnhanced plugin;
    private final FileConfiguration waypointsConfig;
    private Map<Player, String> playerToWaypointNavigating = Map.of();

    public WaypointManager(SurvivalEnhanced plugin) {
        this.plugin = plugin;
        this.waypointsConfig = plugin.getWaypointsConfig();
        this.startNavigationLoop();
    }

    private void startNavigationLoop() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.playerToWaypointNavigating.forEach((player, name) -> {
            if (this.getAllWaypoints((Player)player).contains(name)) {
                if (this.nearbyLocations(player.getLocation(), this.getWaypoint((Player)player, (String)name))) {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aYou reached your destination."));
                    player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    this.stopNavigation((Player)player);
                }
                this.showParticles((Player)player, this.getWaypoint((Player)player, (String)name));
                this.spawnWaypointCircle((Player)player, this.getWaypoint((Player)player, (String)name));
            }
        }), 0L, 20L);
    }

    private boolean nearbyLocations(Location loc1, Location loc2) {
        if (loc1.getWorld() == null || !loc1.getWorld().equals((Object)loc2.getWorld())) {
            return false;
        }
        return loc1.distance(loc2) <= 2.0;
    }

    private void showParticles(Player player, Location waypoint) {
        Location start = player.getEyeLocation().clone().subtract(0.0, 0.6, 0.0);
        Location end = waypoint.clone().add(0.0, 1.0, 0.0);
        Vector direction = end.toVector().subtract(start.toVector()).normalize();
        double maxDistance = 4.0;
        double step = 0.3;
        int particleCount = (int)(maxDistance / step);
        for (int i = 1; i <= particleCount; ++i) {
            Location point = start.clone().add(direction.clone().multiply((double)i * step));
            player.spawnParticle(Particle.END_ROD, point, 1, 0.0, 0.0, 0.0, 0.0);
        }
        double distance = (double)Math.round(player.getLocation().distance(waypoint) * 100.0) / 100.0;
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7a" + distance + " blocks away."));
    }

    private void spawnWaypointCircle(Player player, Location center) {
        if (player.getLocation().distance(center) > 50.0) {
            return;
        }
        Location base = center.clone().add(0.5, 0.1, 0.5);
        double radius = 0.7;
        int points = 24;
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            Location particleLoc = base.clone().add(x, 0.0, z);
            player.spawnParticle(Particle.END_ROD, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void startNavigation(Player player, String name) {
        HashMap<Player, String> newMap = new HashMap<Player, String>(this.playerToWaypointNavigating);
        newMap.put(player, name);
        this.playerToWaypointNavigating = newMap;
    }

    public void stopNavigation(Player player) {
        HashMap<Player, String> newMap = new HashMap<Player, String>(this.playerToWaypointNavigating);
        newMap.remove(player);
        this.playerToWaypointNavigating = newMap;
    }

    public void removeWaypoint(Player player, String name) {
        this.waypointsConfig.set(String.valueOf(player.getUniqueId()) + "." + name, null);
        this.stopNavigation(player);
        try {
            this.waypointsConfig.save(this.plugin.getWaypointsFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openSubMenu(Player player) {
        Inventory inventory = this.plugin.getServer().createInventory(null, 9, "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints");
        ItemStack addWaypointItem = new ItemStack(Material.OAK_SIGN);
        ItemMeta addWaypointItemMeta = addWaypointItem.getItemMeta();
        if (addWaypointItemMeta == null) {
            return;
        }
        addWaypointItemMeta.setDisplayName("\u00a7aAdd Waypoint");
        addWaypointItem.setItemMeta(addWaypointItemMeta);
        inventory.setItem(0, addWaypointItem);
        ItemStack removeWaypointItem = new ItemStack(Material.BARRIER);
        ItemMeta removeWaypointItemMeta = removeWaypointItem.getItemMeta();
        if (removeWaypointItemMeta == null) {
            return;
        }
        removeWaypointItemMeta.setDisplayName("\u00a7cRemove Waypoint");
        removeWaypointItem.setItemMeta(removeWaypointItemMeta);
        inventory.setItem(1, removeWaypointItem);
        ItemStack navigateWaypointItem = new ItemStack(Material.COMPASS);
        ItemMeta navigateWaypointItemMeta = navigateWaypointItem.getItemMeta();
        if (navigateWaypointItemMeta == null) {
            return;
        }
        navigateWaypointItemMeta.setDisplayName("\u00a7aNavigate to Waypoint");
        navigateWaypointItem.setItemMeta(navigateWaypointItemMeta);
        inventory.setItem(2, navigateWaypointItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backItemMeta = backItem.getItemMeta();
        if (backItemMeta == null) {
            return;
        }
        backItemMeta.setDisplayName("\u00a7cBack");
        backItem.setItemMeta(backItemMeta);
        inventory.setItem(8, backItem);
        player.openInventory(inventory);
    }

    public void openWaypointMenu(Player player) {
        if (!this.plugin.getFunctionManager().isFunctionEnabled(Function.WAYPOINTS)) {
            return;
        }
        Inventory inventory = this.plugin.getServer().createInventory(null, 9, "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Navigate");
        for (String waypointName : this.getAllWaypoints(player)) {
            inventory.addItem(new ItemStack[]{this.createWaypointsItem(player, waypointName)});
        }
        ItemStack stopNavigationItem = new ItemStack(Material.BARRIER);
        ItemMeta stopNavigationItemMeta = stopNavigationItem.getItemMeta();
        if (stopNavigationItemMeta == null) {
            return;
        }
        stopNavigationItemMeta.setDisplayName("\u00a7cStop Navigation");
        stopNavigationItem.setItemMeta(stopNavigationItemMeta);
        inventory.setItem(8, stopNavigationItem);
        player.openInventory(inventory);
    }

    private ItemStack createWaypointsItem(Player player, String waypointName) {
        ItemStack itemStack = new ItemStack(Material.NAME_TAG);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        itemMeta.setDisplayName("\u00a7a" + waypointName);
        itemMeta.setLore(List.of("\u00a77" + Math.round(this.getWaypoint(player, waypointName).distance(player.getLocation())) + " \u00a77blocks away"));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public List<String> getAllWaypoints(Player player) {
        ConfigurationSection configurationSection = this.waypointsConfig.getConfigurationSection(player.getUniqueId().toString());
        if (configurationSection == null) {
            return new ArrayList<String>();
        }
        Set keys = configurationSection.getKeys(false);
        return keys.stream().toList();
    }

    public Location getWaypoint(Player player, String name) {
        if (!this.waypointsConfig.contains(String.valueOf(player.getUniqueId()) + "." + name)) {
            return null;
        }
        double x = this.waypointsConfig.getDouble(String.valueOf(player.getUniqueId()) + "." + name + ".x");
        double y = this.waypointsConfig.getDouble(String.valueOf(player.getUniqueId()) + "." + name + ".y");
        double z = this.waypointsConfig.getDouble(String.valueOf(player.getUniqueId()) + "." + name + ".z");
        float yaw = (float)this.waypointsConfig.getDouble(String.valueOf(player.getUniqueId()) + "." + name + ".yaw");
        float pitch = (float)this.waypointsConfig.getDouble(String.valueOf(player.getUniqueId()) + "." + name + ".pitch");
        return new Location(player.getWorld(), x, y, z, yaw, pitch);
    }

    public void addWaypoint(Player player, String name, Location location) {
        this.waypointsConfig.set(String.valueOf(player.getUniqueId()) + "." + name + ".x", (Object)location.getX());
        this.waypointsConfig.set(String.valueOf(player.getUniqueId()) + "." + name + ".y", (Object)location.getY());
        this.waypointsConfig.set(String.valueOf(player.getUniqueId()) + "." + name + ".z", (Object)location.getZ());
        this.waypointsConfig.set(String.valueOf(player.getUniqueId()) + "." + name + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.waypointsConfig.set(String.valueOf(player.getUniqueId()) + "." + name + ".pitch", (Object)Float.valueOf(location.getPitch()));
        try {
            this.waypointsConfig.save(this.plugin.getWaypointsFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

