/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.waypoints;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.waypoints.WaypointManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WaypointInventoryClickListener
implements Listener {
    private final SurvivalEnhanced plugin;
    private final List<Player> playersToCatchMessage;

    public WaypointInventoryClickListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
        this.playersToCatchMessage = new ArrayList<Player>();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        Player player = (Player)event.getWhoClicked();
        switch (title) {
            case "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Navigate": {
                if (event.getCurrentItem() == null) {
                    return;
                }
                if (!event.getCurrentItem().hasItemMeta() || !Objects.requireNonNull(event.getCurrentItem().getItemMeta()).hasDisplayName()) {
                    return;
                }
                String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
                WaypointManager waypointManager = this.plugin.getWaypointManager();
                if (displayName.equals("\u00a7cStop Navigation")) {
                    waypointManager.stopNavigation((Player)event.getWhoClicked());
                    event.setCancelled(true);
                    event.getView().close();
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cStopped Navigation"));
                    return;
                }
                String waypointName = displayName.substring(2);
                Location waypoint = waypointManager.getWaypoint((Player)event.getWhoClicked(), waypointName);
                if (waypoint == null) {
                    return;
                }
                waypointManager.startNavigation((Player)event.getWhoClicked(), waypointName);
                event.setCancelled(true);
                event.getView().close();
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aNavigating to " + waypointName));
                break;
            }
            case "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints": {
                String displayName;
                if (event.getCurrentItem() == null) {
                    return;
                }
                if (!event.getCurrentItem().hasItemMeta() || !Objects.requireNonNull(event.getCurrentItem().getItemMeta()).hasDisplayName()) {
                    return;
                }
                switch (displayName = event.getCurrentItem().getItemMeta().getDisplayName()) {
                    case "\u00a7aAdd Waypoint": {
                        event.setCancelled(true);
                        event.getView().close();
                        this.handleAddWaypointClick(event);
                        break;
                    }
                    case "\u00a7cRemove Waypoint": {
                        event.setCancelled(true);
                        event.getView().close();
                        this.handleRemoveWaypointClick(event, this.plugin);
                        break;
                    }
                    case "\u00a7aNavigate to Waypoint": {
                        this.plugin.getWaypointManager().openWaypointMenu((Player)event.getWhoClicked());
                        break;
                    }
                    case "\u00a7cBack": {
                        event.setCancelled(true);
                        event.getView().close();
                        this.plugin.getPlayerMenuManager().openPlayerMenu((Player)event.getWhoClicked());
                    }
                }
                break;
            }
            case "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Add": {
                if (Objects.requireNonNull(event.getCurrentItem()).getType() != Material.PAPER) break;
                String displayName = Objects.requireNonNull(event.getCurrentItem().getItemMeta()).getDisplayName();
                String name = displayName.replace("\u00a7aEnter waypoint name:", "");
                if (name.isEmpty()) {
                    event.getView().close();
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cName cannot be empty"));
                    return;
                }
                this.plugin.getWaypointManager().addWaypoint((Player)event.getWhoClicked(), name, event.getWhoClicked().getLocation());
                event.getView().close();
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aAdded Waypoint"));
                event.setCancelled(true);
                break;
            }
            case "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Remove": {
                String displayName;
                if (Objects.requireNonNull(event.getCurrentItem()).getType() == Material.PAPER) {
                    String displayName2 = Objects.requireNonNull(event.getCurrentItem().getItemMeta()).getDisplayName();
                    String name = displayName2.substring(2);
                    this.plugin.getWaypointManager().removeWaypoint((Player)event.getWhoClicked(), name);
                    event.getView().close();
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aRemoved Waypoint"));
                    event.setCancelled(true);
                    break;
                }
                if (event.getCurrentItem().getType() != Material.ARROW || !(displayName = Objects.requireNonNull(event.getCurrentItem().getItemMeta()).getDisplayName()).equals("\u00a7cBack")) break;
                event.setCancelled(true);
                event.getView().close();
                this.plugin.getWaypointManager().openSubMenu((Player)event.getWhoClicked());
            }
        }
    }

    public void handleRemoveWaypointClick(InventoryClickEvent event, SurvivalEnhanced plugin) {
        Inventory inventoryToOpen = plugin.getServer().createInventory(null, 9, "\u00a7cSurvival\u00a7eEnhanced \u00a77Waypoints - Remove");
        for (String waypoint : plugin.getWaypointManager().getAllWaypoints((Player)event.getWhoClicked())) {
            ItemStack itemToAdd = new ItemStack(Material.PAPER);
            ItemMeta itemMeta = itemToAdd.getItemMeta();
            if (itemMeta == null) {
                return;
            }
            itemMeta.setDisplayName("\u00a7a" + waypoint);
            itemToAdd.setItemMeta(itemMeta);
            inventoryToOpen.addItem(new ItemStack[]{itemToAdd});
        }
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backItemMeta = backItem.getItemMeta();
        if (backItemMeta == null) {
            return;
        }
        backItemMeta.setDisplayName("\u00a7cBack");
        backItem.setItemMeta(backItemMeta);
        inventoryToOpen.setItem(8, backItem);
        event.getWhoClicked().openInventory(inventoryToOpen);
    }

    public void handleAddWaypointClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        player.sendMessage("\u00a7eType your waypoint name in the chat or type \"cancel\" to cancel.");
        this.playersToCatchMessage.add(player);
    }

    @EventHandler
    public void onChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        String readableMessage = event.getMessage();
        if (readableMessage.isEmpty()) {
            return;
        }
        if (this.playersToCatchMessage.contains(player)) {
            if (readableMessage.equalsIgnoreCase("cancel")) {
                player.sendMessage("\u00a7ccancelled waypoint creation.");
                event.setCancelled(true);
                return;
            }
            this.playersToCatchMessage.remove(player);
            this.plugin.getWaypointManager().addWaypoint(player, readableMessage, player.getLocation());
            player.closeInventory();
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aAdded Waypoint"));
            event.setCancelled(true);
            player.sendMessage("\u00a7aWaypoint " + readableMessage + " added.");
        }
    }
}

