/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.keepWorkbenchItems;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class CraftingTableListener
implements Listener {
    private final SurvivalEnhanced plugin;
    Map<Location, List<ItemStack>> locationToInventoryMatrix = new HashMap<Location, List<ItemStack>>();
    List<Location> locationOfOpenWorkbenches = new ArrayList<Location>();

    public CraftingTableListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (this.plugin.getFunctionManager().isFunctionEnabled(Function.KEEP_WORKBENCH_ITEMS) && event.getInventory().getType() == InventoryType.WORKBENCH) {
            if (!this.locationOfOpenWorkbenches.contains(event.getInventory().getLocation())) {
                this.locationOfOpenWorkbenches.add(event.getInventory().getLocation());
                CraftingInventory inv = (CraftingInventory)event.getInventory();
                Location invLoc = inv.getLocation();
                if (this.locationToInventoryMatrix.containsKey(invLoc)) {
                    List<ItemStack> savedMatrix = this.locationToInventoryMatrix.get(invLoc);
                    ItemStack[] matrix = new ItemStack[9];
                    for (int i = 0; i < savedMatrix.size(); ++i) {
                        if (savedMatrix.get(i) == null || savedMatrix.get(i).getAmount() == 0) continue;
                        matrix[i] = savedMatrix.get(i);
                    }
                    inv.setMatrix(matrix);
                }
            } else {
                event.setCancelled(true);
                event.getPlayer().sendMessage("\u00a7cThis workbench is already opened by another player!");
                Player player = (Player)event.getPlayer();
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cThis workbench is already opened by another player!"));
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.getFunctionManager().isFunctionEnabled(Function.KEEP_WORKBENCH_ITEMS)) {
            Logger logger = this.plugin.getServer().getLogger();
            if (event.getBlock().getType() == Material.CRAFTING_TABLE) {
                logger.info("break is Workbench");
                if (this.locationToInventoryMatrix.containsKey(event.getBlock().getLocation())) {
                    List<ItemStack> itemStacks = this.locationToInventoryMatrix.get(event.getBlock().getLocation());
                    Location location = event.getBlock().getLocation();
                    this.locationToInventoryMatrix.put(event.getBlock().getLocation(), new ArrayList());
                    this.locationToInventoryMatrix.remove(event.getBlock().getLocation());
                    this.locationOfOpenWorkbenches.remove(event.getBlock().getLocation());
                    for (ItemStack itemStack : itemStacks) {
                        if (itemStack == null || itemStack.getAmount() <= 0) continue;
                        event.getBlock().getWorld().dropItemNaturally(location, itemStack);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.plugin.getFunctionManager().isFunctionEnabled(Function.KEEP_WORKBENCH_ITEMS) && event.getInventory().getType() == InventoryType.WORKBENCH) {
            this.locationOfOpenWorkbenches.remove(event.getInventory().getLocation());
            CraftingInventory inv = (CraftingInventory)event.getInventory();
            Location invLoc = inv.getLocation();
            ArrayList<ItemStack> matrixToSave = new ArrayList<ItemStack>(Arrays.asList(inv.getMatrix()));
            this.locationToInventoryMatrix.put(invLoc, matrixToSave);
            event.getInventory().clear();
        }
    }
}

