/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.functionManager;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FunctionManager {
    private final SurvivalEnhanced plugin;
    List<Function> enabledFunctions = new ArrayList<Function>();

    public FunctionManager(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    public boolean isFunctionEnabled(Function function) {
        return this.enabledFunctions.contains((Object)function);
    }

    public void enableFunction(Function function) {
        this.enabledFunctions.add(function);
    }

    public void disableFunction(Function function) {
        this.enabledFunctions.remove((Object)function);
    }

    Inventory createFunctionManagerInventory() {
        Inventory gui = this.plugin.getServer().createInventory(null, 18, "\u00a7cSurvival\u00a7eEnhanced \u00a77Functions");
        gui.setItem(0, this.createFunctionItem("\u00a7aAnvil Level Limiter", Material.ANVIL, Function.ANVIL_LEVEL_LIMITER));
        gui.setItem(1, this.createFunctionItem("\u00a7aKeep Workbench Items", Material.CRAFTING_TABLE, Function.KEEP_WORKBENCH_ITEMS));
        gui.setItem(2, this.createFunctionItem("\u00a7aCompact Bonemeal", Material.BONE_BLOCK, Function.COMPACT_BONEMEAL));
        gui.setItem(3, this.createFunctionItem("\u00a7aAuto Open Connected Doors", Material.OAK_DOOR, Function.AUTO_OPEN_CONNECTED_DOORS));
        gui.setItem(4, this.createFunctionItem("\u00a7aAuto Replace Saplings", Material.OAK_SAPLING, Function.AUTO_REPLACE_SAPLING));
        gui.setItem(5, this.createFunctionItem("\u00a7aAuto Torch Placer", Material.TORCH, Function.AUTO_TORCH_PLACER));
        gui.setItem(6, this.createFunctionItem("\u00a7aWaypoints", Material.NAME_TAG, Function.WAYPOINTS));
        gui.setItem(7, this.createFunctionItem("\u00a7aBetter Sleep", Material.RED_BED, Function.BETTER_SLEEP));
        gui.setItem(8, this.createFunctionItem("\u00a7aAuto Replant Crops", Material.WHEAT, Function.AUTO_REPLANT_CROPS));
        gui.setItem(9, this.createFunctionItem("\u00a7aBreadcrumb Trails", Material.LEATHER_BOOTS, Function.BREADCRUMB));
        return gui;
    }

    private ItemStack createFunctionItem(String displayName, Material itemMaterial, Function function) {
        String toggleFunctionText;
        String loreFunctionActive;
        ItemStack item = new ItemStack(itemMaterial, 1);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        itemMeta.setDisplayName(displayName);
        if (this.plugin.getFunctionManager().isFunctionEnabled(function)) {
            loreFunctionActive = "\u00a7aActive";
            toggleFunctionText = "\u00a7cDeactivate";
        } else {
            loreFunctionActive = "\u00a7cInactive";
            toggleFunctionText = "\u00a7aActivate";
        }
        itemMeta.setLore(List.of("\u00a7eThis function is " + loreFunctionActive, "\u00a7eClick to " + toggleFunctionText));
        item.setItemMeta(itemMeta);
        return item;
    }
}

