/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.compactBonemeal;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class CropClickListener
implements Listener {
    private final SurvivalEnhanced plugin;

    public CropClickListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCropClick(PlayerInteractEvent event) {
        if (this.plugin.getFunctionManager().isFunctionEnabled(Function.COMPACT_BONEMEAL)) {
            if (event.getClickedBlock() == null) {
                return;
            }
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock != null && (clickedBlock.getType() == Material.WHEAT || clickedBlock.getType() == Material.CARROTS || clickedBlock.getType() == Material.POTATO) && event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.BONE_BLOCK)) {
                event.setCancelled(true);
                List<Block> affectedBlocks = this.getAffectedBlocks(event.getPlayer(), clickedBlock);
                affectedBlocks.forEach(this::letCropGrow);
                if (event.getPlayer().getInventory().getItemInMainHand().getAmount() == 1) {
                    event.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR, 1));
                } else {
                    event.getPlayer().getInventory().getItemInMainHand().setAmount(event.getPlayer().getInventory().getItemInMainHand().getAmount() - 1);
                }
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block clickedBlock;
        if (this.plugin.getFunctionManager().isFunctionEnabled(Function.COMPACT_BONEMEAL) && ((clickedBlock = event.getBlockAgainst()).getType() == Material.WHEAT || clickedBlock.getType() == Material.CARROTS || clickedBlock.getType() == Material.POTATO) && event.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.BONE_BLOCK)) {
            event.setCancelled(true);
            List<Block> affectedBlocks = this.getAffectedBlocks(event.getPlayer(), clickedBlock);
            int i = 0;
            for (Block block : affectedBlocks) {
                Ageable ageable;
                BlockData blockData = block.getBlockData();
                if (!(blockData instanceof Ageable) || (ageable = (Ageable)blockData).getAge() != ageable.getMaximumAge()) continue;
                ++i;
            }
            if (i == affectedBlocks.size()) {
                return;
            }
            affectedBlocks.forEach(this::letCropGrow);
            if (event.getPlayer().getInventory().getItemInMainHand().getAmount() == 1) {
                event.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR, 1));
            } else {
                event.getPlayer().getInventory().getItemInMainHand().setAmount(event.getPlayer().getInventory().getItemInMainHand().getAmount() - 1);
            }
        }
    }

    private List<Block> getAffectedBlocks(Player player, Block center) {
        BlockFace right;
        BlockFace left;
        ArrayList<Block> result = new ArrayList<Block>();
        BlockFace face = this.yawToFace(player.getLocation().getYaw());
        switch (face) {
            case NORTH: {
                left = BlockFace.WEST;
                right = BlockFace.EAST;
                break;
            }
            case SOUTH: {
                left = BlockFace.EAST;
                right = BlockFace.WEST;
                break;
            }
            case EAST: {
                left = BlockFace.NORTH;
                right = BlockFace.SOUTH;
                break;
            }
            case WEST: {
                left = BlockFace.SOUTH;
                right = BlockFace.NORTH;
                break;
            }
            default: {
                return List.of(center);
            }
        }
        result.add(center);
        result.add(center.getRelative(left));
        result.add(center.getRelative(right));
        return result;
    }

    private BlockFace yawToFace(float yaw) {
        int rotation = Math.round(yaw / 90.0f) & 3;
        return switch (rotation) {
            case 0 -> BlockFace.SOUTH;
            case 1 -> BlockFace.WEST;
            case 2 -> BlockFace.NORTH;
            case 3 -> BlockFace.EAST;
            default -> BlockFace.SOUTH;
        };
    }

    private void letCropGrow(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            ageable.setAge(ageable.getMaximumAge());
            block.setBlockData((BlockData)ageable);
        }
    }
}

