/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.automaticTorchPlacer;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutomaticTorchPlacerManager {
    private final List<Player> torchPlacers = new ArrayList<Player>();
    private final Map<UUID, Location> lastTorchPlaced = new HashMap<UUID, Location>();
    private static final double MIN_DISTANCE_BETWEEN_TORCHES = 6.0;

    public AutomaticTorchPlacerManager(final SurvivalEnhanced plugin) {
        new BukkitRunnable(){

            public void run() {
                if (!plugin.getFunctionManager().isFunctionEnabled(Function.AUTO_TORCH_PLACER)) {
                    return;
                }
                for (Player player : AutomaticTorchPlacerManager.this.torchPlacers) {
                    Location lastPlaced;
                    Location currentLoc;
                    Block standingOn;
                    Block placeAt;
                    ItemStack offHand;
                    if (!player.isOnline() || (offHand = player.getInventory().getItemInOffHand()).getType() != Material.TORCH || offHand.getAmount() <= 0 || (placeAt = (standingOn = (currentLoc = player.getLocation()).getBlock().getRelative(BlockFace.DOWN)).getRelative(BlockFace.UP)).getLightLevel() >= 8 || (lastPlaced = AutomaticTorchPlacerManager.this.lastTorchPlaced.get(player.getUniqueId())) != null && Objects.equals(lastPlaced.getWorld(), currentLoc.getWorld()) && lastPlaced.distanceSquared(currentLoc) < 36.0 || placeAt.getType() != Material.AIR || !standingOn.getType().isSolid() || !placeAt.getRelative(BlockFace.DOWN).getType().isSolid() || placeAt.getRelative(BlockFace.DOWN).getType() == Material.SHORT_GRASS) continue;
                    placeAt.setType(Material.TORCH);
                    offHand.setAmount(offHand.getAmount() - 1);
                    player.getInventory().setItemInOffHand(offHand);
                    AutomaticTorchPlacerManager.this.lastTorchPlaced.put(player.getUniqueId(), placeAt.getLocation());
                    player.playSound(currentLoc, Sound.BLOCK_WOOD_PLACE, 0.6f, 1.2f);
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 5L);
    }

    public List<Player> getTorchPlacers() {
        return this.torchPlacers;
    }

    public void toggleTorchPlacer(Player player) {
        if (this.torchPlacers.contains(player)) {
            this.torchPlacers.remove(player);
            this.lastTorchPlaced.remove(player.getUniqueId());
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cTorch placer disabled"));
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_OFF, 1.0f, 1.0f);
        } else {
            this.torchPlacers.add(player);
            this.lastTorchPlaced.remove(player.getUniqueId());
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aTorch placer enabled"));
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
        }
    }
}

