/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced.anvilLevelLimiter;

import de.silver.survivalEnhanced.SurvivalEnhanced;
import de.silver.survivalEnhanced.functionManager.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.plugin.Plugin;

public class AnvilListener
implements Listener {
    private SurvivalEnhanced plugin;
    private List<AnvilInventory> anvilInventoriesToUpdate = new ArrayList<AnvilInventory>();

    public AnvilListener(SurvivalEnhanced plugin) {
        this.plugin = plugin;
        this.updateAnvilInventories(plugin);
    }

    private void updateAnvilInventories(SurvivalEnhanced plugin) {
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> {
            if (plugin.getFunctionManager().isFunctionEnabled(Function.ANVIL_LEVEL_LIMITER)) {
                for (AnvilInventory anvilInventory : this.anvilInventoriesToUpdate) {
                    Logger logger = plugin.getServer().getLogger();
                    anvilInventory.setMaximumRepairCost(Integer.MAX_VALUE);
                    if (anvilInventory.getRepairCost() <= 35 && anvilInventory.getRepairCostAmount() <= 35) continue;
                    anvilInventory.setRepairCost(35);
                    anvilInventory.setRepairCostAmount(35);
                }
            }
        }, 0L, 5L);
    }

    @EventHandler
    public void onAnvilOpen(InventoryOpenEvent event) {
        Logger logger = this.plugin.getServer().getLogger();
        if (event.getInventory().getType() == InventoryType.ANVIL && !this.anvilInventoriesToUpdate.contains(event.getInventory())) {
            this.anvilInventoriesToUpdate.add((AnvilInventory)event.getInventory());
        }
    }

    @EventHandler
    public void onAnvilClose(InventoryCloseEvent event) {
        if (event.getInventory().getType() == InventoryType.ANVIL) {
            AnvilInventory anvilInventory = (AnvilInventory)event.getInventory();
            this.anvilInventoriesToUpdate.remove(anvilInventory);
        }
    }
}

