/*
 * Decompiled with CFR 0.152.
 */
package de.silver.survivalEnhanced;

import de.silver.survivalEnhanced.anvilLevelLimiter.AnvilListener;
import de.silver.survivalEnhanced.autoOpenConnectedDoors.DoorOpenListener;
import de.silver.survivalEnhanced.autoReplaceSaplings.BlockBreakListener;
import de.silver.survivalEnhanced.automaticTorchPlacer.AutomaticTorchPlacerManager;
import de.silver.survivalEnhanced.automaticTorchPlacer.PlayerJoinListener;
import de.silver.survivalEnhanced.betterSleepSystem.PlayerSleepListener;
import de.silver.survivalEnhanced.compactBonemeal.CropClickListener;
import de.silver.survivalEnhanced.functionManager.Function;
import de.silver.survivalEnhanced.functionManager.FunctionManager;
import de.silver.survivalEnhanced.functionManager.SurvivalEnhancedCommand;
import de.silver.survivalEnhanced.keepWorkbenchItems.CraftingTableListener;
import de.silver.survivalEnhanced.playermenu.InventoryClickListener;
import de.silver.survivalEnhanced.playermenu.PlayerMenuCommand;
import de.silver.survivalEnhanced.playermenu.PlayerMenuManager;
import de.silver.survivalEnhanced.waypoints.WaypointInventoryClickListener;
import de.silver.survivalEnhanced.waypoints.WaypointManager;
import de.silver.survivalEnhanced.waypoints.WaypointPlayerLeaveListener;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SurvivalEnhanced
extends JavaPlugin {
    private FileConfiguration functionsConfig;
    private FileConfiguration torchPlacerConfig;
    private FileConfiguration waypointsConfig;
    private AutomaticTorchPlacerManager torchPlacerManager;
    private PlayerMenuManager playerMenuManager;
    private File waypointsFile;
    private WaypointManager waypointManager;
    private de.silver.survivalEnhanced.autoReplantCrops.BlockBreakListener cropListener;
    private FunctionManager functionManager;

    public void onEnable() {
        File functionsFile = new File(this.getDataFolder(), "functions.yml");
        if (!functionsFile.exists()) {
            this.getDataFolder().mkdirs();
            try {
                functionsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create functions.yml file");
            }
        }
        this.functionsConfig = YamlConfiguration.loadConfiguration((File)functionsFile);
        File torchPlacerFile = new File(this.getDataFolder(), "torchPlacer.yml");
        if (!torchPlacerFile.exists()) {
            this.getDataFolder().mkdirs();
            try {
                torchPlacerFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create torchPlacer.yml file");
            }
        }
        this.torchPlacerConfig = YamlConfiguration.loadConfiguration((File)torchPlacerFile);
        this.waypointsFile = new File(this.getDataFolder(), "waypoints.yml");
        if (!this.waypointsFile.exists()) {
            this.getDataFolder().mkdirs();
            try {
                this.waypointsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create waypoints.yml file");
            }
        }
        this.waypointsConfig = YamlConfiguration.loadConfiguration((File)this.waypointsFile);
        this.functionManager = new FunctionManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new AnvilListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftingTableListener(this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("survivalenhanced")).setExecutor((CommandExecutor)new SurvivalEnhancedCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new de.silver.survivalEnhanced.functionManager.InventoryClickListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DoorOpenListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WaypointInventoryClickListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WaypointPlayerLeaveListener(this), (Plugin)this);
        this.waypointManager = new WaypointManager(this);
        this.torchPlacerManager = new AutomaticTorchPlacerManager(this);
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (!this.torchPlacerConfig.getBoolean(player.getName(), false)) continue;
            this.torchPlacerManager.getTorchPlacers().add(player);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aYour Torch placer is still enabled."));
        }
        for (Function function : Function.values()) {
            if (!this.functionsConfig.getBoolean(function.name(), false)) continue;
            this.functionManager.enableFunction(function);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new CropClickListener(this), (Plugin)this);
        this.playerMenuManager = new PlayerMenuManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("menu")).setExecutor((CommandExecutor)new PlayerMenuCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerSleepListener(this), (Plugin)this);
        this.cropListener = new de.silver.survivalEnhanced.autoReplantCrops.BlockBreakListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.cropListener, (Plugin)this);
    }

    public static void main(String[] args) {
    }

    public void onDisable() {
        for (Function function : Function.values()) {
            this.functionsConfig.set(function.name(), (Object)this.functionManager.isFunctionEnabled(function));
        }
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (this.torchPlacerManager.getTorchPlacers().contains(player)) {
                this.torchPlacerConfig.set(player.getName(), (Object)true);
                continue;
            }
            this.torchPlacerConfig.set(player.getName(), (Object)false);
        }
        try {
            this.functionsConfig.save(new File(this.getDataFolder(), "functions.yml"));
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save functions.yml");
        }
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public AutomaticTorchPlacerManager getAutomaticTorchPlacerManager() {
        return this.torchPlacerManager;
    }

    public boolean playerExistsInConfig(Player player) {
        return this.torchPlacerConfig.get(player.getName()) != null;
    }

    public void addPlayerToConfigInitial(Player player) {
        this.torchPlacerConfig.set(player.getName(), (Object)false);
    }

    public PlayerMenuManager getPlayerMenuManager() {
        return this.playerMenuManager;
    }

    public FileConfiguration getWaypointsConfig() {
        return this.waypointsConfig;
    }

    public File getWaypointsFile() {
        return this.waypointsFile;
    }

    public WaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    public de.silver.survivalEnhanced.autoReplantCrops.BlockBreakListener getCropListener() {
        return this.cropListener;
    }
}

