/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.v1_21_4.nms;

import cn.lunadeer.dominion.nms.FakeEntity;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FakeEntityImpl
implements FakeEntity {
    private static final DataWatcherObject<Byte> DATA_SHARED_FLAGS_ID;
    private static final DataWatcherObject<Integer> INTERPOLATION_START;
    private static final DataWatcherObject<Integer> INTERPOLATION_DURATION;
    private static final DataWatcherObject<Integer> POS_ROT_INTERPOLATION_DURATION;
    private static final DataWatcherObject<Vector3f> TRANSLATION;
    private static final DataWatcherObject<Vector3f> SCALE;
    private static final DataWatcherObject<Quaternionf> LEFT_ROTATION;
    private static final DataWatcherObject<Quaternionf> RIGHT_ROTATION;
    private static final DataWatcherObject<Byte> BILLBOARD;
    private static final DataWatcherObject<Integer> BRIGHTNESS;
    private static final DataWatcherObject<Float> VIEW_RANGE;
    private static final DataWatcherObject<Float> SHADOW_RADIUS;
    private static final DataWatcherObject<Float> SHADOW_STRENGTH;
    private static final DataWatcherObject<Float> WIDTH;
    private static final DataWatcherObject<Float> HEIGHT;
    private static final DataWatcherObject<Integer> GLOW_COLOR;
    private static final DataWatcherObject<IBlockData> BLOCK_STATE_ACCESSOR;
    private static final DataWatcherObject<net.minecraft.world.item.ItemStack> ITEM_STACK_ACCESSOR;
    private static final DataWatcherObject<Byte> ITEM_TRANSFORM;
    private final int entityId;
    private final UUID uuid;
    private final FakeEntity.DisplayType displayType;
    private Location location;
    private int interpolationDelay = 0;
    private int interpolationDuration = 0;
    private int posRotInterpolationDuration = 0;
    private Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Quaternionf leftRotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private Quaternionf rightRotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private byte billboard = 0;
    private int brightness = -1;
    private float viewRange = 1.0f;
    private float shadowRadius = 0.0f;
    private float shadowStrength = 1.0f;
    private float width = 0.0f;
    private float height = 0.0f;
    private int glowColorOverride = -1;
    private byte entityFlags = 0;
    private IBlockData blockState;
    private net.minecraft.world.item.ItemStack nmsItemStack;
    private byte itemTransform = 0;

    private static Map<Integer, DataWatcherObject<?>> resolveAccessors(Class<?> clazz) {
        HashMap map = new HashMap();
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !DataWatcherObject.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                DataWatcherObject accessor = (DataWatcherObject)field.get(null);
                map.put(accessor.a(), accessor);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access Display metadata field: " + field.getName(), e);
            }
        }
        return map;
    }

    FakeEntityImpl(int entityId, Location location, FakeEntity.DisplayType displayType, BlockData blockData, ItemStack itemStack) {
        this.entityId = entityId;
        this.uuid = UUID.randomUUID();
        this.displayType = displayType;
        this.location = location.clone();
        if (displayType == FakeEntity.DisplayType.BLOCK_DISPLAY && blockData != null) {
            this.blockState = FakeEntityImpl.toNmsBlockState(blockData);
        }
        if (displayType == FakeEntity.DisplayType.ITEM_DISPLAY && itemStack != null) {
            this.nmsItemStack = FakeEntityImpl.toNmsItemStack(itemStack);
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public FakeEntity.DisplayType getDisplayType() {
        return this.displayType;
    }

    @Override
    public void spawn(Collection<? extends Player> players) {
        List<Packet<?>> packets = this.createSpawnPackets();
        ClientboundBundlePacket bundle = new ClientboundBundlePacket(packets);
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)bundle);
        }
    }

    @Override
    public void spawn(Player player) {
        this.spawn(Collections.singleton(player));
    }

    @Override
    public void destroy(Collection<? extends Player> players) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{this.entityId});
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)packet);
        }
    }

    @Override
    public void destroy(Player player) {
        this.destroy(Collections.singleton(player));
    }

    @Override
    public void teleport(Location location, Collection<? extends Player> players) {
        this.location = location.clone();
        PacketPlayOutEntityTeleport packet = this.createTeleportPacket();
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)packet);
        }
    }

    @Override
    public void teleport(Location location, Player player) {
        this.teleport(location, Collections.singleton(player));
    }

    @Override
    public void setTranslation(Vector3f translation) {
        this.translation = new Vector3f((Vector3fc)translation);
    }

    @Override
    public void setScale(Vector3f scale) {
        this.scale = new Vector3f((Vector3fc)scale);
    }

    @Override
    public void setLeftRotation(Quaternionf rotation) {
        this.leftRotation = new Quaternionf((Quaternionfc)rotation);
    }

    @Override
    public void setRightRotation(Quaternionf rotation) {
        this.rightRotation = new Quaternionf((Quaternionfc)rotation);
    }

    @Override
    public void setBillboard(byte mode) {
        this.billboard = mode;
    }

    @Override
    public void setBrightness(int blockLight, int skyLight) {
        this.brightness = blockLight << 4 | skyLight << 20;
    }

    @Override
    public void setViewRange(float range) {
        this.viewRange = range;
    }

    @Override
    public void setShadow(float radius, float strength) {
        this.shadowRadius = radius;
        this.shadowStrength = strength;
    }

    @Override
    public void setGlowColor(Color color) {
        if (color == null) {
            this.glowColorOverride = -1;
            this.entityFlags = (byte)(this.entityFlags & 0xFFFFFFBF);
        } else {
            this.glowColorOverride = color.asARGB();
            this.entityFlags = (byte)(this.entityFlags | 0x40);
        }
    }

    @Override
    public void setInterpolationDuration(int ticks) {
        this.interpolationDuration = ticks;
    }

    @Override
    public void setInterpolationDelay(int ticks) {
        this.interpolationDelay = ticks;
    }

    @Override
    public void setBlockData(BlockData blockData) {
        if (this.displayType != FakeEntity.DisplayType.BLOCK_DISPLAY) {
            return;
        }
        this.blockState = FakeEntityImpl.toNmsBlockState(blockData);
    }

    @Override
    public void setItemStack(ItemStack itemStack) {
        if (this.displayType != FakeEntity.DisplayType.ITEM_DISPLAY) {
            return;
        }
        this.nmsItemStack = FakeEntityImpl.toNmsItemStack(itemStack);
    }

    @Override
    public void setItemTransform(byte transform) {
        if (this.displayType != FakeEntity.DisplayType.ITEM_DISPLAY) {
            return;
        }
        this.itemTransform = transform;
    }

    @Override
    public void sendMetadata(Collection<? extends Player> players) {
        PacketPlayOutEntityMetadata packet = this.createMetadataPacket();
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)packet);
        }
    }

    @Override
    public void sendMetadata(Player player) {
        this.sendMetadata(Collections.singleton(player));
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    private void sendPacket(Player player, Packet<?> packet) {
        FakeEntityImpl.getServerPlayer((Player)player).f.b(packet);
    }

    private List<Packet<?>> createSpawnPackets() {
        ArrayList packets = new ArrayList();
        EntityTypes entityType = this.displayType == FakeEntity.DisplayType.BLOCK_DISPLAY ? EntityTypes.p : EntityTypes.ar;
        PacketPlayOutSpawnEntity spawnPacket = new PacketPlayOutSpawnEntity(this.entityId, this.uuid, this.location.getX(), this.location.getY(), this.location.getZ(), 0.0f, 0.0f, entityType, 0, Vec3D.c, 0.0);
        packets.add((Packet<?>)spawnPacket);
        packets.add((Packet<?>)this.createMetadataPacket());
        return packets;
    }

    private PacketPlayOutEntityMetadata createMetadataPacket() {
        ArrayList<DataWatcher.c> dataValues = new ArrayList<DataWatcher.c>();
        dataValues.add(DataWatcher.c.a(DATA_SHARED_FLAGS_ID, (Object)this.entityFlags));
        dataValues.add(DataWatcher.c.a(INTERPOLATION_START, (Object)this.interpolationDelay));
        dataValues.add(DataWatcher.c.a(INTERPOLATION_DURATION, (Object)this.interpolationDuration));
        dataValues.add(DataWatcher.c.a(POS_ROT_INTERPOLATION_DURATION, (Object)this.posRotInterpolationDuration));
        dataValues.add(DataWatcher.c.a(TRANSLATION, (Object)this.translation));
        dataValues.add(DataWatcher.c.a(SCALE, (Object)this.scale));
        dataValues.add(DataWatcher.c.a(LEFT_ROTATION, (Object)this.leftRotation));
        dataValues.add(DataWatcher.c.a(RIGHT_ROTATION, (Object)this.rightRotation));
        dataValues.add(DataWatcher.c.a(BILLBOARD, (Object)this.billboard));
        dataValues.add(DataWatcher.c.a(BRIGHTNESS, (Object)this.brightness));
        dataValues.add(DataWatcher.c.a(VIEW_RANGE, (Object)Float.valueOf(this.viewRange)));
        dataValues.add(DataWatcher.c.a(SHADOW_RADIUS, (Object)Float.valueOf(this.shadowRadius)));
        dataValues.add(DataWatcher.c.a(SHADOW_STRENGTH, (Object)Float.valueOf(this.shadowStrength)));
        dataValues.add(DataWatcher.c.a(WIDTH, (Object)Float.valueOf(this.width)));
        dataValues.add(DataWatcher.c.a(HEIGHT, (Object)Float.valueOf(this.height)));
        dataValues.add(DataWatcher.c.a(GLOW_COLOR, (Object)this.glowColorOverride));
        if (this.displayType == FakeEntity.DisplayType.BLOCK_DISPLAY && this.blockState != null) {
            dataValues.add(DataWatcher.c.a(BLOCK_STATE_ACCESSOR, (Object)this.blockState));
        } else if (this.displayType == FakeEntity.DisplayType.ITEM_DISPLAY) {
            if (this.nmsItemStack != null) {
                dataValues.add(DataWatcher.c.a(ITEM_STACK_ACCESSOR, (Object)this.nmsItemStack.v()));
            }
            dataValues.add(DataWatcher.c.a(ITEM_TRANSFORM, (Object)this.itemTransform));
        }
        return new PacketPlayOutEntityMetadata(this.entityId, dataValues);
    }

    private PacketPlayOutEntityTeleport createTeleportPacket() {
        PositionMoveRotation positionMoveRotation = new PositionMoveRotation(new Vec3D(this.location.getX(), this.location.getY(), this.location.getZ()), Vec3D.c, this.location.getYaw(), this.location.getPitch());
        return new PacketPlayOutEntityTeleport(this.entityId, positionMoveRotation, Set.of(), false);
    }

    private static EntityPlayer getServerPlayer(Player player) {
        try {
            return (EntityPlayer)player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get ServerPlayer handle", e);
        }
    }

    private static IBlockData toNmsBlockState(BlockData blockData) {
        try {
            return (IBlockData)blockData.getClass().getMethod("getState", new Class[0]).invoke((Object)blockData, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert BlockData to NMS BlockState", e);
        }
    }

    private static net.minecraft.world.item.ItemStack toNmsItemStack(ItemStack itemStack) {
        try {
            String cbPkg = Bukkit.getServer().getClass().getPackage().getName();
            Class<?> cls = Class.forName(cbPkg + ".inventory.CraftItemStack");
            return (net.minecraft.world.item.ItemStack)cls.getMethod("asNMSCopy", ItemStack.class).invoke(null, itemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert ItemStack to NMS", e);
        }
    }

    static {
        Map<Integer, DataWatcherObject<?>> ea = FakeEntityImpl.resolveAccessors(Entity.class);
        Map<Integer, DataWatcherObject<?>> da = FakeEntityImpl.resolveAccessors(Display.class);
        Map<Integer, DataWatcherObject<?>> bda = FakeEntityImpl.resolveAccessors(Display.BlockDisplay.class);
        Map<Integer, DataWatcherObject<?>> ida = FakeEntityImpl.resolveAccessors(Display.ItemDisplay.class);
        DATA_SHARED_FLAGS_ID = ea.get(0);
        INTERPOLATION_START = da.get(8);
        INTERPOLATION_DURATION = da.get(9);
        POS_ROT_INTERPOLATION_DURATION = da.get(10);
        TRANSLATION = da.get(11);
        SCALE = da.get(12);
        LEFT_ROTATION = da.get(13);
        RIGHT_ROTATION = da.get(14);
        BILLBOARD = da.get(15);
        BRIGHTNESS = da.get(16);
        VIEW_RANGE = da.get(17);
        SHADOW_RADIUS = da.get(18);
        SHADOW_STRENGTH = da.get(19);
        WIDTH = da.get(20);
        HEIGHT = da.get(21);
        GLOW_COLOR = da.get(22);
        BLOCK_STATE_ACCESSOR = bda.get(23);
        ITEM_STACK_ACCESSOR = ida.get(23);
        ITEM_TRANSFORM = ida.get(24);
    }
}

