/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.v1_20_1.nms;

import cn.lunadeer.dominion.nms.FakeEntity;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FakeEntityImpl
implements FakeEntity {
    private static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = new EntityDataAccessor(0, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> INTERPOLATION_START = new EntityDataAccessor(8, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> INTERPOLATION_DURATION = new EntityDataAccessor(9, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Vector3f> TRANSLATION = new EntityDataAccessor(10, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Vector3f> SCALE = new EntityDataAccessor(11, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Quaternionf> LEFT_ROTATION = new EntityDataAccessor(12, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Quaternionf> RIGHT_ROTATION = new EntityDataAccessor(13, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Byte> BILLBOARD = new EntityDataAccessor(14, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> BRIGHTNESS = new EntityDataAccessor(15, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> VIEW_RANGE = new EntityDataAccessor(16, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SHADOW_RADIUS = new EntityDataAccessor(17, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SHADOW_STRENGTH = new EntityDataAccessor(18, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> WIDTH = new EntityDataAccessor(19, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HEIGHT = new EntityDataAccessor(20, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> GLOW_COLOR = new EntityDataAccessor(21, EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockState> BLOCK_STATE_ACCESSOR = new EntityDataAccessor(22, EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<net.minecraft.world.item.ItemStack> ITEM_STACK_ACCESSOR = new EntityDataAccessor(22, EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Byte> ITEM_TRANSFORM = new EntityDataAccessor(23, EntityDataSerializers.BYTE);
    private final int entityId;
    private final UUID uuid;
    private final FakeEntity.DisplayType displayType;
    private Location location;
    private int interpolationDelay = 0;
    private int interpolationDuration = 0;
    private Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Quaternionf leftRotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private Quaternionf rightRotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private byte billboard = 0;
    private int brightness = -1;
    private float viewRange = 1.0f;
    private float shadowRadius = 0.0f;
    private float shadowStrength = 1.0f;
    private float width = 0.0f;
    private float height = 0.0f;
    private int glowColorOverride = -1;
    private byte entityFlags = 0;
    private BlockState blockState;
    private net.minecraft.world.item.ItemStack nmsItemStack;
    private byte itemTransform = 0;

    FakeEntityImpl(int entityId, Location location, FakeEntity.DisplayType displayType, BlockData blockData, ItemStack itemStack) {
        this.entityId = entityId;
        this.uuid = UUID.randomUUID();
        this.displayType = displayType;
        this.location = location.clone();
        if (displayType == FakeEntity.DisplayType.BLOCK_DISPLAY && blockData != null) {
            this.blockState = ((CraftBlockData)blockData).getState();
        }
        if (displayType == FakeEntity.DisplayType.ITEM_DISPLAY && itemStack != null) {
            this.nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public FakeEntity.DisplayType getDisplayType() {
        return this.displayType;
    }

    @Override
    public void spawn(Collection<? extends Player> players) {
        List<Packet<?>> packets = this.createSpawnPackets();
        ClientboundBundlePacket bundle = new ClientboundBundlePacket(packets);
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)bundle);
        }
    }

    @Override
    public void spawn(Player player) {
        this.spawn(Collections.singleton(player));
    }

    @Override
    public void destroy(Collection<? extends Player> players) {
        ClientboundRemoveEntitiesPacket packet = new ClientboundRemoveEntitiesPacket(new int[]{this.entityId});
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)packet);
        }
    }

    @Override
    public void destroy(Player player) {
        this.destroy(Collections.singleton(player));
    }

    @Override
    public void teleport(Location location, Collection<? extends Player> players) {
        this.location = location.clone();
        ClientboundTeleportEntityPacket packet = this.createTeleportPacket();
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)packet);
        }
    }

    @Override
    public void teleport(Location location, Player player) {
        this.teleport(location, Collections.singleton(player));
    }

    @Override
    public void setTranslation(Vector3f translation) {
        this.translation = new Vector3f((Vector3fc)translation);
    }

    @Override
    public void setScale(Vector3f scale) {
        this.scale = new Vector3f((Vector3fc)scale);
    }

    @Override
    public void setLeftRotation(Quaternionf rotation) {
        this.leftRotation = new Quaternionf((Quaternionfc)rotation);
    }

    @Override
    public void setRightRotation(Quaternionf rotation) {
        this.rightRotation = new Quaternionf((Quaternionfc)rotation);
    }

    @Override
    public void setBillboard(byte mode) {
        this.billboard = mode;
    }

    @Override
    public void setBrightness(int blockLight, int skyLight) {
        this.brightness = blockLight << 4 | skyLight << 20;
    }

    @Override
    public void setViewRange(float range) {
        this.viewRange = range;
    }

    @Override
    public void setShadow(float radius, float strength) {
        this.shadowRadius = radius;
        this.shadowStrength = strength;
    }

    @Override
    public void setGlowColor(Color color) {
        if (color == null) {
            this.glowColorOverride = -1;
            this.entityFlags = (byte)(this.entityFlags & 0xFFFFFFBF);
        } else {
            this.glowColorOverride = color.asARGB();
            this.entityFlags = (byte)(this.entityFlags | 0x40);
        }
    }

    @Override
    public void setInterpolationDuration(int ticks) {
        this.interpolationDuration = ticks;
    }

    @Override
    public void setInterpolationDelay(int ticks) {
        this.interpolationDelay = ticks;
    }

    @Override
    public void setBlockData(BlockData blockData) {
        if (this.displayType != FakeEntity.DisplayType.BLOCK_DISPLAY) {
            return;
        }
        this.blockState = ((CraftBlockData)blockData).getState();
    }

    @Override
    public void setItemStack(ItemStack itemStack) {
        if (this.displayType != FakeEntity.DisplayType.ITEM_DISPLAY) {
            return;
        }
        this.nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    @Override
    public void setItemTransform(byte transform) {
        if (this.displayType != FakeEntity.DisplayType.ITEM_DISPLAY) {
            return;
        }
        this.itemTransform = transform;
    }

    @Override
    public void sendMetadata(Collection<? extends Player> players) {
        ClientboundSetEntityDataPacket packet = this.createMetadataPacket();
        for (Player player : players) {
            this.sendPacket(player, (Packet<?>)packet);
        }
    }

    @Override
    public void sendMetadata(Player player) {
        this.sendMetadata(Collections.singleton(player));
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().connection.send(packet);
    }

    private List<Packet<?>> createSpawnPackets() {
        ArrayList packets = new ArrayList();
        EntityType entityType = this.displayType == FakeEntity.DisplayType.BLOCK_DISPLAY ? EntityType.BLOCK_DISPLAY : EntityType.ITEM_DISPLAY;
        ClientboundAddEntityPacket spawnPacket = new ClientboundAddEntityPacket(this.entityId, this.uuid, this.location.getX(), this.location.getY(), this.location.getZ(), 0.0f, 0.0f, entityType, 0, Vec3.ZERO, 0.0);
        packets.add((Packet<?>)spawnPacket);
        packets.add((Packet<?>)this.createMetadataPacket());
        return packets;
    }

    private ClientboundSetEntityDataPacket createMetadataPacket() {
        ArrayList<SynchedEntityData.DataValue> dataValues = new ArrayList<SynchedEntityData.DataValue>();
        dataValues.add(SynchedEntityData.DataValue.create(DATA_SHARED_FLAGS_ID, (Object)this.entityFlags));
        dataValues.add(SynchedEntityData.DataValue.create(INTERPOLATION_START, (Object)this.interpolationDelay));
        dataValues.add(SynchedEntityData.DataValue.create(INTERPOLATION_DURATION, (Object)this.interpolationDuration));
        dataValues.add(SynchedEntityData.DataValue.create(TRANSLATION, (Object)this.translation));
        dataValues.add(SynchedEntityData.DataValue.create(SCALE, (Object)this.scale));
        dataValues.add(SynchedEntityData.DataValue.create(LEFT_ROTATION, (Object)this.leftRotation));
        dataValues.add(SynchedEntityData.DataValue.create(RIGHT_ROTATION, (Object)this.rightRotation));
        dataValues.add(SynchedEntityData.DataValue.create(BILLBOARD, (Object)this.billboard));
        dataValues.add(SynchedEntityData.DataValue.create(BRIGHTNESS, (Object)this.brightness));
        dataValues.add(SynchedEntityData.DataValue.create(VIEW_RANGE, (Object)Float.valueOf(this.viewRange)));
        dataValues.add(SynchedEntityData.DataValue.create(SHADOW_RADIUS, (Object)Float.valueOf(this.shadowRadius)));
        dataValues.add(SynchedEntityData.DataValue.create(SHADOW_STRENGTH, (Object)Float.valueOf(this.shadowStrength)));
        dataValues.add(SynchedEntityData.DataValue.create(WIDTH, (Object)Float.valueOf(this.width)));
        dataValues.add(SynchedEntityData.DataValue.create(HEIGHT, (Object)Float.valueOf(this.height)));
        dataValues.add(SynchedEntityData.DataValue.create(GLOW_COLOR, (Object)this.glowColorOverride));
        if (this.displayType == FakeEntity.DisplayType.BLOCK_DISPLAY && this.blockState != null) {
            dataValues.add(SynchedEntityData.DataValue.create(BLOCK_STATE_ACCESSOR, (Object)this.blockState));
        } else if (this.displayType == FakeEntity.DisplayType.ITEM_DISPLAY) {
            if (this.nmsItemStack != null) {
                dataValues.add(SynchedEntityData.DataValue.create(ITEM_STACK_ACCESSOR, (Object)this.nmsItemStack.copy()));
            }
            dataValues.add(SynchedEntityData.DataValue.create(ITEM_TRANSFORM, (Object)this.itemTransform));
        }
        return new ClientboundSetEntityDataPacket(this.entityId, dataValues);
    }

    private ClientboundTeleportEntityPacket createTeleportPacket() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(this.entityId);
        buf.writeDouble(this.location.getX());
        buf.writeDouble(this.location.getY());
        buf.writeDouble(this.location.getZ());
        buf.writeByte((int)((byte)(this.location.getYaw() * 256.0f / 360.0f)));
        buf.writeByte((int)((byte)(this.location.getPitch() * 256.0f / 360.0f)));
        buf.writeBoolean(false);
        ClientboundTeleportEntityPacket packet = new ClientboundTeleportEntityPacket(buf);
        buf.release();
        return packet;
    }
}

