/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.scheduler;

import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.scheduler.CancellableTask;
import cn.lunadeer.dominion.utils.scheduler.PaperTask;
import cn.lunadeer.dominion.utils.scheduler.SpigotTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Scheduler {
    public static Scheduler instance;
    private final JavaPlugin plugin;
    private boolean isPaper = false;

    public Scheduler(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.isPaper = Misc.isPaper();
    }

    public static void cancelAll() {
        if (Scheduler.instance.isPaper) {
            Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)Scheduler.instance.plugin);
            Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)Scheduler.instance.plugin);
        } else {
            Scheduler.instance.plugin.getServer().getScheduler().cancelTasks((Plugin)Scheduler.instance.plugin);
        }
    }

    public static CancellableTask runTaskLater(Runnable task, long delay) {
        if (delay <= 0L) {
            Scheduler.runTask(task);
            return null;
        }
        if (Scheduler.instance.isPaper) {
            return new PaperTask(Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay));
        }
        return new SpigotTask(Scheduler.instance.plugin.getServer().getScheduler().runTaskLater((Plugin)Scheduler.instance.plugin, task, delay));
    }

    public static CancellableTask runTask(Runnable task) {
        if (Scheduler.instance.isPaper) {
            return new PaperTask(Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().run((Plugin)Scheduler.instance.plugin, plugin -> task.run()));
        }
        return new SpigotTask(Scheduler.instance.plugin.getServer().getScheduler().runTask((Plugin)Scheduler.instance.plugin, task));
    }

    public static CancellableTask runTaskRepeat(Runnable task, long delay, long period) {
        if (Scheduler.instance.isPaper) {
            return new PaperTask(Scheduler.instance.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay, period));
        }
        return new SpigotTask(Scheduler.instance.plugin.getServer().getScheduler().runTaskTimer((Plugin)Scheduler.instance.plugin, task, delay, period));
    }

    public static CancellableTask runTaskLaterAsync(Runnable task, long delay) {
        if (delay <= 0L) {
            Scheduler.runTaskAsync(task);
            return null;
        }
        if (Scheduler.instance.isPaper) {
            return new PaperTask(Scheduler.instance.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay * 50L, TimeUnit.MILLISECONDS));
        }
        return new SpigotTask(Scheduler.instance.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)Scheduler.instance.plugin, task, delay));
    }

    public static CancellableTask runTaskAsync(Runnable task) {
        if (Scheduler.instance.isPaper) {
            return new PaperTask(Scheduler.instance.plugin.getServer().getAsyncScheduler().runNow((Plugin)Scheduler.instance.plugin, plugin -> task.run()));
        }
        return new SpigotTask(Scheduler.instance.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)Scheduler.instance.plugin, task));
    }

    public static CancellableTask runTaskRepeatAsync(Runnable task, long delay, long period) {
        if (Scheduler.instance.isPaper) {
            return new PaperTask(Scheduler.instance.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)Scheduler.instance.plugin, plugin -> task.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS));
        }
        return new SpigotTask(Scheduler.instance.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)Scheduler.instance.plugin, task, delay, period));
    }

    public static CancellableTask runEntityTask(Runnable task, Entity entity) {
        if (Scheduler.instance.isPaper) {
            return new PaperTask(entity.getScheduler().run((Plugin)Scheduler.instance.plugin, plugin -> task.run(), null));
        }
        return new SpigotTask(Scheduler.instance.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)Scheduler.instance.plugin, task));
    }
}

