/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.holograme;

import cn.lunadeer.dominion.utils.holograme.HoloElement;
import cn.lunadeer.dominion.utils.holograme.HoloItem;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;

public class HoloManager {
    private static final HoloManager INSTANCE = new HoloManager();
    private final Map<String, HoloItem> items = new LinkedHashMap<String, HoloItem>();

    private HoloManager() {
    }

    public static HoloManager instance() {
        return INSTANCE;
    }

    public HoloItem create(String name, Location anchor) {
        if (this.items.containsKey(name)) {
            throw new IllegalArgumentException("HoloItem '" + name + "' already exists");
        }
        HoloItem item = new HoloItem(name, anchor);
        this.items.put(name, item);
        return item;
    }

    public HoloItem get(String name) {
        return this.items.get(name);
    }

    public boolean exists(String name) {
        return this.items.containsKey(name);
    }

    public void remove(String name) {
        HoloItem item = this.items.remove(name);
        if (item != null) {
            item.hideAll();
            for (HoloElement element : item.getElements()) {
                element.remove();
            }
        }
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.items.keySet());
    }

    public Collection<HoloItem> getAll() {
        return Collections.unmodifiableCollection(this.items.values());
    }

    public int count() {
        return this.items.size();
    }

    public void removeAll() {
        for (HoloItem item : this.items.values()) {
            item.hideAll();
            for (HoloElement element : item.getElements()) {
                element.remove();
            }
        }
        this.items.clear();
    }

    void untrack(String name) {
        this.items.remove(name);
    }
}

