/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.syntax;

import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import cn.lunadeer.dominion.utils.databse.syntax.Syntax;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public abstract class Update
implements Syntax {
    protected final String tableName;
    protected Field<?>[] fields;
    protected String where;
    protected Object[] whereArgs;

    public static Update update(String tableName) {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.SQLITE -> new sqlite_impl(tableName);
            case DatabaseType.MYSQL -> new mysql_impl(tableName);
            case DatabaseType.PGSQL -> new pgsql_impl(tableName);
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported with UPDATE");
        };
    }

    private Update(String tableName) {
        this.tableName = tableName;
    }

    public Update set(Field<?> ... fields) {
        this.fields = fields;
        return this;
    }

    public Update where(String conditions, Object ... args) {
        this.where = conditions;
        this.whereArgs = args;
        return this;
    }

    public int execute() throws SQLException {
        int n;
        block10: {
            Connection conn = DatabaseManager.instance.getConnection();
            try {
                String sql = this.getSql();
                PreparedStatement preparedStatement = conn.prepareStatement(sql);
                int index = 1;
                for (Field<?> field : this.fields) {
                    preparedStatement.setObject(index++, field.getValue());
                }
                for (Object arg : this.whereArgs) {
                    preparedStatement.setObject(index++, arg);
                }
                n = preparedStatement.executeUpdate();
                if (conn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    XLogger.error("SQL: " + this.getSql());
                    XLogger.error("SET Param: " + String.valueOf(Arrays.stream(this.fields).map(Field::getValue)));
                    XLogger.error("WHERE Param: " + String.valueOf(List.of(this.whereArgs)));
                    XLogger.error(e);
                    throw new SQLException("Error executing update: " + e.getMessage(), e);
                }
            }
            conn.close();
        }
        return n;
    }

    private static class sqlite_impl
    extends Update {
        private sqlite_impl(String tableName) {
            super(tableName);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder("UPDATE " + this.tableName + " SET ");
            for (Field field : this.fields) {
                sql.append(field.getName()).append(" = ?, ");
            }
            sql.delete(sql.length() - 2, sql.length());
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            return sql.toString();
        }
    }

    private static class mysql_impl
    extends Update {
        private mysql_impl(String tableName) {
            super(tableName);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder("UPDATE " + this.tableName + " SET ");
            for (Field field : this.fields) {
                sql.append(field.getName()).append(" = ?, ");
            }
            sql.delete(sql.length() - 2, sql.length());
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            return sql.toString();
        }
    }

    private static class pgsql_impl
    extends Update {
        private pgsql_impl(String tableName) {
            super(tableName);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder("UPDATE " + this.tableName + " SET ");
            for (Field field : this.fields) {
                sql.append(field.getName()).append(" = ?, ");
            }
            sql.delete(sql.length() - 2, sql.length());
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            return sql.toString();
        }
    }
}

