/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.syntax.Table;

import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import cn.lunadeer.dominion.utils.databse.syntax.Syntax;

public abstract class Column
implements Syntax {
    protected Field<?> column;
    protected boolean primary = false;
    protected boolean serial = false;
    protected boolean notNull = false;
    protected boolean unique = false;
    protected Field<?>[] joinUnique = null;
    protected String foreignTableName = null;
    protected Field<?> foreignColumn = null;
    protected String defaultValue = null;

    public static Column of(Field<?> column) {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.PGSQL -> new pgsql_impl(column);
            case DatabaseType.SQLITE -> new sqlite_impl(column);
            case DatabaseType.MYSQL -> new mysql_impl(column);
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported with COLUMN");
        };
    }

    private Column(Field<?> field) {
        this.column = field;
    }

    public Field<?> getColumn() {
        return this.column;
    }

    public Column primary() {
        this.primary = true;
        return this;
    }

    public Column serial() {
        this.serial = true;
        return this;
    }

    public Column foreign(String tableName, Field<?> column) {
        this.foreignTableName = tableName;
        this.foreignColumn = column;
        return this;
    }

    public Column notNull() {
        this.notNull = true;
        return this;
    }

    public Column unique() {
        this.unique = true;
        return this;
    }

    public Column unique(Field<?> ... fields) {
        this.joinUnique = fields;
        return this;
    }

    public Column defaultSqlVal(String value) {
        this.defaultValue = value;
        return this;
    }

    private static class pgsql_impl
    extends Column {
        public pgsql_impl(Field<?> column) {
            super(column);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder();
            sql.append(this.column.getName()).append(" ");
            if (this.serial) {
                sql.append(" SERIAL");
            } else {
                sql.append(this.column.getSqlTypeStr());
                if (this.notNull) {
                    sql.append(" NOT NULL");
                }
                if (this.unique) {
                    sql.append(" UNIQUE");
                }
                if (this.defaultValue != null) {
                    sql.append(" DEFAULT ").append(this.defaultValue);
                }
            }
            if (this.primary) {
                sql.append(" PRIMARY KEY");
            }
            if (this.joinUnique != null) {
                sql.append(" UNIQUE (");
                for (Field field : this.joinUnique) {
                    sql.append(field.getName()).append(", ");
                }
                sql.delete(sql.length() - 2, sql.length());
                sql.append(")");
            }
            if (this.foreignTableName != null && this.foreignColumn != null) {
                sql.append(" REFERENCES ").append(this.foreignTableName).append("(").append(this.foreignColumn.getName()).append(") ON DELETE CASCADE");
            }
            return sql.toString();
        }
    }

    private static class sqlite_impl
    extends Column {
        public sqlite_impl(Field<?> field) {
            super(field);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder();
            sql.append(this.column.getName()).append(" ").append(this.column.getSqlTypeStr());
            if (this.primary) {
                sql.append(" PRIMARY KEY");
            }
            if (this.serial) {
                sql.append(" AUTOINCREMENT");
            }
            if (this.notNull) {
                sql.append(" NOT NULL");
            }
            if (this.unique) {
                sql.append(" UNIQUE");
            }
            if (this.defaultValue != null) {
                sql.append(" DEFAULT ").append(this.defaultValue);
            }
            if (this.joinUnique != null) {
                sql.append(" UNIQUE (");
                for (Field field : this.joinUnique) {
                    sql.append(field.getName()).append(", ");
                }
                sql.delete(sql.length() - 2, sql.length());
                sql.append(")");
            }
            if (this.foreignTableName != null && this.foreignColumn != null) {
                sql.append(" REFERENCES ").append(this.foreignTableName).append("(").append(this.foreignColumn.getName()).append(") ON DELETE CASCADE");
            }
            return sql.toString();
        }
    }

    private static class mysql_impl
    extends Column {
        public mysql_impl(Field<?> field) {
            super(field);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder();
            sql.append(this.column.getName()).append(" ").append(this.column.getSqlTypeStr());
            if (this.primary) {
                sql.append(" PRIMARY KEY");
            }
            if (this.serial) {
                sql.append(" AUTO_INCREMENT");
            }
            if (this.notNull) {
                sql.append(" NOT NULL");
            }
            if (this.unique) {
                sql.append(" UNIQUE");
            }
            if (this.defaultValue != null) {
                sql.append(" DEFAULT ").append(this.defaultValue);
            }
            if (this.joinUnique != null) {
                sql.append(" UNIQUE (");
                for (Field field : this.joinUnique) {
                    sql.append(field.getName()).append(", ");
                }
                sql.delete(sql.length() - 2, sql.length());
                sql.append(")");
            }
            if (this.foreignTableName != null && this.foreignColumn != null) {
                sql.append(" REFERENCES ").append(this.foreignTableName).append("(").append(this.foreignColumn.getName()).append(") ON DELETE CASCADE");
            }
            return sql.toString();
        }
    }
}

