/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.FIelds;

import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import java.util.List;

public class FieldString
extends Field<String> {
    private String value;

    public FieldString(String name) {
        super(name);
    }

    public FieldString(String name, String value) {
        super(name);
        this.value = value;
    }

    @Override
    public String getSqlTypeStr() {
        return FieldString.getTypeStrings().get(0);
    }

    @Override
    public String getUnifyTypeStr() {
        return "STRING";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Field<String> setValue(String value) {
        this.value = value;
        return this;
    }

    public static List<String> getTypeStrings() {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.MYSQL -> List.of("VARCHAR(255)", "VARCHAR", "TEXT");
            case DatabaseType.SQLITE -> List.of("TEXT", "VARCHAR", "VARCHAR(36)");
            case DatabaseType.PGSQL -> List.of("TEXT", "VARCHAR", "CHARACTER VARYING");
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported FieldString");
        };
    }
}

