/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.configuration;

import cn.lunadeer.dominion.utils.configuration.Comment;
import cn.lunadeer.dominion.utils.configuration.Comments;
import cn.lunadeer.dominion.utils.configuration.ConfigurationFile;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.configuration.HandleManually;
import cn.lunadeer.dominion.utils.configuration.Headers;
import cn.lunadeer.dominion.utils.configuration.PostProcess;
import cn.lunadeer.dominion.utils.configuration.PreProcess;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager {
    public static ConfigurationFile load(Class<? extends ConfigurationFile> clazz, File file) throws Exception {
        if (!file.exists()) {
            return ConfigurationManager.saveDefault(clazz, file);
        }
        ConfigurationFile instance = ConfigurationManager.readConfigurationFile(YamlConfiguration.loadConfiguration((File)file), clazz);
        instance.save(file);
        return instance;
    }

    public static ConfigurationFile load(Class<? extends ConfigurationFile> clazz, File file, String versionFieldName) throws Exception {
        Field versionField = clazz.getField(versionFieldName);
        int currentVersion = versionField.getInt(null);
        ConfigurationFile instance = ConfigurationManager.load(clazz, file);
        if (versionField.getInt(null) != currentVersion) {
            File backup = new File(file.getParentFile(), file.getName() + ".bak");
            if (backup.exists() && !backup.delete()) {
                throw new Exception("Failed to delete the backup configuration file.");
            }
            if (!file.renameTo(backup)) {
                throw new Exception("Failed to backup the configuration file.");
            }
            clazz.getField(versionFieldName).set(null, currentVersion);
            return ConfigurationManager.saveDefault(clazz, file);
        }
        return instance;
    }

    public static ConfigurationFile saveDefault(Class<? extends ConfigurationFile> clazz, File file) throws Exception {
        ConfigurationManager.createIfNotExist(file);
        YamlConfiguration yaml = ConfigurationManager.writeConfigurationFile(clazz);
        yaml.options().width(250);
        yaml.save(file);
        return ConfigurationManager.load(clazz, file);
    }

    private static YamlConfiguration writeConfigurationFile(Class<? extends ConfigurationFile> clazz) throws Exception {
        YamlConfiguration yaml = new YamlConfiguration();
        if (clazz.isAnnotationPresent(Headers.class)) {
            yaml.options().setHeader(List.of(clazz.getAnnotation(Headers.class).value()));
        }
        ConfigurationFile instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        ConfigurationManager.writeConfigurationPart((ConfigurationSection)yaml, instance, null);
        return yaml;
    }

    public static void writeConfigurationPart(ConfigurationSection yaml, ConfigurationPart obj, String prefix) throws Exception {
        ConfigurationManager.writeConfigurationPart(yaml, obj, prefix, false);
    }

    public static void writeConfigurationPart(ConfigurationSection yaml, ConfigurationPart obj, String prefix, boolean ignoreComment) throws Exception {
        for (Field field : obj.getClass().getFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(HandleManually.class)) continue;
            Object newKey = ConfigurationManager.camelToKebab(field.getName());
            if (prefix != null && !prefix.isEmpty()) {
                newKey = prefix + "." + (String)newKey;
            }
            if (ConfigurationPart.class.isAssignableFrom(field.getType())) {
                ConfigurationManager.writeConfigurationPart(yaml, (ConfigurationPart)field.get(obj), (String)newKey);
            } else {
                yaml.set((String)newKey, field.get(obj));
            }
            if (ignoreComment) continue;
            if (field.isAnnotationPresent(Comments.class)) {
                yaml.setComments((String)newKey, List.of(field.getAnnotation(Comments.class).value()));
            }
            if (!field.isAnnotationPresent(Comment.class)) continue;
            yaml.setInlineComments((String)newKey, List.of(field.getAnnotation(Comment.class).value()));
        }
    }

    private static void createIfNotExist(File file) throws Exception {
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new Exception("Failed to create %s directory.".formatted(file.getParentFile().getAbsolutePath()));
        }
        if (!file.createNewFile()) {
            throw new Exception("Failed to create %s file.".formatted(file.getAbsolutePath()));
        }
    }

    private static ConfigurationFile readConfigurationFile(YamlConfiguration yaml, Class<? extends ConfigurationFile> clazz) throws Exception {
        ConfigurationFile instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        instance.setYaml(yaml);
        PrePostProcessInorder processes = ConfigurationManager.getAndSortPrePostProcess(clazz);
        for (Method method : processes.preProcessMethods) {
            method.invoke((Object)instance, new Object[0]);
        }
        ConfigurationManager.readConfigurationPart((ConfigurationSection)instance.getYaml(), instance, null);
        for (Method method : processes.postProcessMethods) {
            method.invoke((Object)instance, new Object[0]);
        }
        return instance;
    }

    public static ConfigurationPart readConfigurationPart(ConfigurationSection yaml, ConfigurationPart obj, String prefix) throws Exception {
        for (Field field : obj.getClass().getFields()) {
            boolean missingKey;
            field.setAccessible(true);
            if (field.isAnnotationPresent(HandleManually.class)) continue;
            Object key = ConfigurationManager.camelToKebab(field.getName());
            if (prefix != null && !prefix.isEmpty()) {
                key = prefix + "." + (String)key;
            }
            boolean bl = missingKey = !yaml.contains((String)key);
            if (missingKey) {
                yaml.createSection((String)key);
                if (field.isAnnotationPresent(Comments.class)) {
                    yaml.setComments((String)key, List.of(field.getAnnotation(Comments.class).value()));
                }
                if (field.isAnnotationPresent(Comment.class)) {
                    yaml.setInlineComments((String)key, List.of(field.getAnnotation(Comment.class).value()));
                }
            }
            if (ConfigurationPart.class.isAssignableFrom(field.getType())) {
                field.set(obj, ConfigurationManager.readConfigurationPart(yaml, (ConfigurationPart)field.get(obj), (String)key));
                continue;
            }
            if (missingKey) {
                yaml.set((String)key, field.get(obj));
                continue;
            }
            field.set(obj, yaml.get((String)key));
        }
        return obj;
    }

    private static String camelToKebab(String camel) {
        return camel.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
    }

    private static PrePostProcessInorder getAndSortPrePostProcess(Class<? extends ConfigurationFile> clazz) {
        HashMap<Method, Integer> preProcessMethodsWithPriority = new HashMap<Method, Integer>();
        HashMap<Method, Integer> postProcessMethodsWithPriority = new HashMap<Method, Integer>();
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(PreProcess.class)) {
                preProcessMethodsWithPriority.put(method, method.getAnnotation(PreProcess.class).priority());
            }
            if (!method.isAnnotationPresent(PostProcess.class)) continue;
            postProcessMethodsWithPriority.put(method, method.getAnnotation(PostProcess.class).priority());
        }
        PrePostProcessInorder result = new PrePostProcessInorder();
        result.preProcessMethods = new ArrayList(preProcessMethodsWithPriority.keySet());
        result.preProcessMethods.sort(Comparator.comparingInt(preProcessMethodsWithPriority::get));
        result.postProcessMethods = new ArrayList(postProcessMethodsWithPriority.keySet());
        result.postProcessMethods.sort(Comparator.comparingInt(postProcessMethodsWithPriority::get));
        return result;
    }

    private static class PrePostProcessInorder {
        public List<Method> preProcessMethods = new ArrayList<Method>();
        public List<Method> postProcessMethods = new ArrayList<Method>();

        private PrePostProcessInorder() {
        }
    }
}

