/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.command;

import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor,
Listener {
    private static CommandManager instance;
    private static String rootCommand;
    private final JavaPlugin plugin;
    private Consumer<CommandSender> rootCommandConsumer = null;
    public SecondaryCommand helpCommand;
    private static final Map<String, SecondaryCommand> commands;
    private static final Map<String, SecondaryCommand> commandsUsable;

    public static CommandManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("CommandManager is not initialized.");
        }
        return instance;
    }

    public CommandManager(JavaPlugin plugin, String rootCommand) {
        this(plugin, rootCommand, null);
    }

    public CommandManager(JavaPlugin plugin, String rootCommand, Consumer<CommandSender> rootCommandConsumer) {
        if (instance != null) {
            throw new IllegalStateException("CommandManager is already initialized.");
        }
        instance = this;
        CommandManager.rootCommand = "/" + rootCommand;
        Objects.requireNonNull(Bukkit.getPluginCommand((String)rootCommand)).setExecutor((CommandExecutor)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        this.rootCommandConsumer = rootCommandConsumer;
        this.helpCommand = new SecondaryCommand("help", List.of(new Argument("page", "1")), "Displays help information for commands."){

            @Override
            public void executeHandler(CommandSender sender) {
                CommandManager.this.printHelp(sender, this.getArguments().get(0).getValue());
            }
        }.register();
        if (this.rootCommandConsumer == null) {
            this.rootCommandConsumer = sender -> this.printHelp((CommandSender)sender, "1");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.getServer().getOnlinePlayers().isEmpty()) {
            for (String cmd : commands.keySet()) {
                if (!commands.get(cmd).isDynamic()) continue;
                CommandManager.unregisterCommand(cmd);
            }
        }
    }

    public static String getRootCommand() {
        return rootCommand;
    }

    public static void registerCommand(SecondaryCommand command) {
        commands.put(command.getCommand(), command);
        if (!command.isDynamic()) {
            commandsUsable.put(command.getCommand(), command);
        }
    }

    public static void unregisterCommand(SecondaryCommand command) {
        commands.remove(command.getCommand());
        commandsUsable.remove(command.getCommand());
    }

    public static void unregisterCommand(String command) {
        commands.remove(command);
        commandsUsable.remove(command);
    }

    public static SecondaryCommand getCommand(String command) {
        return commands.get(command);
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 0) {
            if (this.rootCommandConsumer != null) {
                try {
                    this.rootCommandConsumer.accept(commandSender);
                }
                catch (Exception e) {
                    commandSender.sendMessage(e.getMessage());
                }
            }
            return true;
        }
        SecondaryCommand cmd = CommandManager.getCommand(strings[0]);
        if (cmd == null) {
            return true;
        }
        try {
            cmd.run(commandSender, strings);
        }
        catch (Exception e) {
            commandSender.sendMessage(e.getMessage());
            this.plugin.getLogger().severe(e.getMessage());
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 1) {
            return new ArrayList<String>(commandsUsable.keySet().stream().filter(cmd -> cmd.startsWith(strings[0])).toList());
        }
        SecondaryCommand cmd2 = CommandManager.getCommand(strings[0]);
        if (cmd2 == null) {
            return null;
        }
        List<Argument> args = cmd2.getArguments();
        if (strings.length - 1 > args.size()) {
            return null;
        }
        String[] suggestionPreArg = new String[strings.length - 1];
        for (int i = 1; i < strings.length - 1; ++i) {
            args.get(i - 1).setValue(strings[i]);
            suggestionPreArg[i - 1] = strings[i];
        }
        return args.get(strings.length - 2).getSuggestion().get(commandSender, suggestionPreArg);
    }

    private void printHelp(CommandSender sender, String pageStr) {
        int page;
        if (commands.isEmpty()) {
            return;
        }
        int pageSize = sender instanceof Player ? 10 : 25;
        try {
            page = Integer.parseInt(pageStr);
        }
        catch (NumberFormatException e) {
            page = 1;
        }
        int totalPages = (int)Math.ceil((double)commandsUsable.size() / (double)pageSize);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        String header = "&a------------ [" + pageStr + "/" + totalPages + "] ------------";
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)header));
        int start = (page - 1) * pageSize;
        int end = Math.min(start + pageSize, commandsUsable.size());
        int index = 0;
        for (String cmd : commandsUsable.keySet()) {
            if (index >= start && index < end) {
                Object line = commandsUsable.get(cmd).getUsage();
                if (!commandsUsable.get(cmd).getDescription().isEmpty()) {
                    line = (String)line + "&8 - &b" + commandsUsable.get(cmd).getDescription();
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            ++index;
        }
    }

    static {
        commands = new HashMap<String, SecondaryCommand>();
        commandsUsable = new HashMap<String, SecondaryCommand>();
    }
}

