/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.VaultConnect;

import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.VaultConnect.Vault;
import cn.lunadeer.dominion.utils.VaultConnect.Vault2;
import cn.lunadeer.dominion.utils.VaultConnect.VaultInterface;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VaultConnect
implements Listener {
    public static VaultConnect instance;
    private VaultInterface vaultInstance = null;
    private final JavaPlugin plugin;

    public VaultConnect(JavaPlugin plugin) {
        this.plugin = plugin;
        instance = this;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnable(ServiceRegisterEvent event) {
    }

    private void assertEconomy() throws Exception {
        if (this.vaultInstance == null) {
            Plugin vaultPlugin = this.plugin.getServer().getPluginManager().getPlugin("Vault");
            if (vaultPlugin == null) {
                throw new Exception(Language.vaultConnectText.vaultUnavailable);
            }
            this.vaultInstance = vaultPlugin.getDescription().getAuthors().contains("creatorfromhell") ? new Vault2() : new Vault();
            if (!this.vaultInstance.init(this.plugin)) {
                this.vaultInstance = null;
                throw new Exception(Language.vaultConnectText.economyUnavailable);
            }
        }
        XLogger.debug("Vault connected.");
    }

    public String currencyNamePlural() throws Exception {
        this.assertEconomy();
        return this.vaultInstance.currencyNamePlural();
    }

    public String currencyNameSingular() throws Exception {
        this.assertEconomy();
        return this.vaultInstance.currencyNameSingular();
    }

    public void withdrawPlayer(Player player, double amount) throws Exception {
        this.assertEconomy();
        if (amount > this.getBalance(player)) {
            throw new Exception(Misc.formatString(Language.vaultConnectText.insufficientFunds, amount, this.currencyNamePlural(), this.getBalance(player)));
        }
        this.vaultInstance.withdrawPlayer((OfflinePlayer)player, amount);
    }

    public void depositPlayer(Player player, double amount) throws Exception {
        this.assertEconomy();
        this.vaultInstance.depositPlayer((OfflinePlayer)player, amount);
    }

    public double getBalance(Player player) throws Exception {
        this.assertEconomy();
        return this.vaultInstance.getBalance((OfflinePlayer)player);
    }

    private static boolean foundClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static class VaultConnectText
    extends ConfigurationPart {
        public String vaultUnavailable = "Vault not available, please install Vault or VaultUnlock to use economy features.";
        public String economyUnavailable = "Economy plugin not found, you need to install one Economy plugin to use economy features.";
        public String insufficientFunds = "Insufficient money, need {0} {1}, but only have {2} {1}.";
    }
}

