/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;

public class ColorParser {
    public static TextComponent getComponentType(String text) {
        String[] parts = text.split("&#");
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        for (String part : parts) {
            String content;
            if (part.isEmpty()) continue;
            TextColor color = TextColor.fromHexString((String)"#ffffff");
            if (part.length() >= 6 && part.substring(0, 6).matches("^[0-9a-fA-F]{6}$")) {
                String color_str = part.substring(0, 6);
                color = TextColor.fromHexString((String)("#" + color_str));
                content = part.substring(6);
            } else {
                content = part;
            }
            components.add(Component.text((String)content, (TextColor)color));
        }
        TextComponent.Builder title_component = Component.text();
        for (TextComponent component : components) {
            title_component.append((Component)component);
        }
        return (TextComponent)title_component.build();
    }

    public static String getBukkitType(String text) {
        Object title = "&f" + text + "&f";
        title = ((String)title).replaceAll("&#", "#");
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher((CharSequence)title);
        while (matcher.find()) {
            String hexCode = matcher.group();
            StringBuilder builder = new StringBuilder("&x");
            for (char c2 : hexCode.substring(1).toCharArray()) {
                builder.append('&').append(c2);
            }
            title = ((String)title).replace(hexCode, builder.toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)title);
    }

    public static String getPlainText(String text) {
        String[] parts = text.split("&#");
        StringBuilder res = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            String content = part.length() >= 6 && part.substring(0, 6).matches("^[0-9a-fA-F]{6}$") ? part.substring(6) : part;
            res.append(content);
        }
        return res.toString();
    }
}

