/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.utils.holograme.HoloItem;
import cn.lunadeer.dominion.utils.holograme.HoloManager;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BorderRenderUtil {
    private static final long DISPLAY_DURATION_TICKS = 200L;
    private static final float WALL_THICKNESS = 0.08f;
    private static final Material BORDER_MATERIAL = Material.WHITE_STAINED_GLASS;
    public static final Color DEFAULT_GLOW_COLOR = Color.fromRGB((int)0, (int)180, (int)255);

    public static void showBorder(CommandSender sender, DominionDTO dominion) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        BorderRenderUtil.showBorder(player, dominion.getWorld(), dominion.getCuboid(), Color.fromRGB((int)dominion.getColorR(), (int)dominion.getColorG(), (int)dominion.getColorB()));
    }

    public static void showBorder(Player player, DominionDTO dominion) {
        BorderRenderUtil.showBorder(player, dominion.getWorld(), dominion.getCuboid(), Color.fromRGB((int)dominion.getColorR(), (int)dominion.getColorG(), (int)dominion.getColorB()));
    }

    public static void showBorder(Player player, World world, CuboidDTO cuboid, Color GLOW_COLOR) {
        Scheduler.runTask(() -> BorderRenderUtil.showBorderDisplay(player, world, cuboid, GLOW_COLOR));
    }

    private static void showBorderDisplay(Player player, World world, CuboidDTO cuboid, Color GLOW_COLOR) {
        if (player == null || !player.isOnline() || world == null) {
            return;
        }
        String holoName = "border_" + String.valueOf(player.getUniqueId());
        if (HoloManager.instance().exists(holoName)) {
            HoloManager.instance().remove(holoName);
        }
        int x1 = cuboid.x1();
        int y1 = cuboid.y1();
        int z1 = cuboid.z1();
        int x2 = cuboid.x2();
        int y2 = cuboid.y2();
        int z2 = cuboid.z2();
        float sizeX = x2 - x1;
        float sizeY = y2 - y1;
        float sizeZ = z2 - z1;
        if (sizeX <= 0.0f || sizeY <= 0.0f || sizeZ <= 0.0f) {
            return;
        }
        Location anchor = new Location(world, (double)x1, (double)y1, (double)z1);
        HoloItem border = HoloManager.instance().create(holoName, anchor);
        border.addBlockDisplay("bottom_north", BORDER_MATERIAL).offset(0.0f, 0.0f, 0.0f).scale(sizeX, 0.08f, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("bottom_south", BORDER_MATERIAL).offset(0.0f, 0.0f, sizeZ).scale(sizeX, 0.08f, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("bottom_west", BORDER_MATERIAL).offset(0.0f, 0.0f, 0.0f).scale(0.08f, 0.08f, sizeZ).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("bottom_east", BORDER_MATERIAL).offset(sizeX, 0.0f, 0.0f).scale(0.08f, 0.08f, sizeZ).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("top_north", BORDER_MATERIAL).offset(0.0f, sizeY, 0.0f).scale(sizeX, 0.08f, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("top_south", BORDER_MATERIAL).offset(0.0f, sizeY, sizeZ).scale(sizeX, 0.08f, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("top_west", BORDER_MATERIAL).offset(0.0f, sizeY, 0.0f).scale(0.08f, 0.08f, sizeZ).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("top_east", BORDER_MATERIAL).offset(sizeX, sizeY, 0.0f).scale(0.08f, 0.08f, sizeZ).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("vertical_nw", BORDER_MATERIAL).offset(0.0f, 0.0f, 0.0f).scale(0.08f, sizeY, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("vertical_ne", BORDER_MATERIAL).offset(sizeX, 0.0f, 0.0f).scale(0.08f, sizeY, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("vertical_sw", BORDER_MATERIAL).offset(0.0f, 0.0f, sizeZ).scale(0.08f, sizeY, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        border.addBlockDisplay("vertical_se", BORDER_MATERIAL).offset(sizeX, 0.0f, sizeZ).scale(0.08f, sizeY, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
        double playerY = player.getLocation().getY();
        if (playerY >= (double)y1 && playerY <= (double)y2) {
            float playerOffsetY = (float)(playerY - (double)y1);
            border.addBlockDisplay("player_north", BORDER_MATERIAL).offset(0.0f, playerOffsetY, 0.0f).scale(sizeX, 0.08f, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
            border.addBlockDisplay("player_south", BORDER_MATERIAL).offset(0.0f, playerOffsetY, sizeZ).scale(sizeX, 0.08f, 0.08f).brightness(15, 15).glowColor(GLOW_COLOR);
            border.addBlockDisplay("player_west", BORDER_MATERIAL).offset(0.0f, playerOffsetY, 0.0f).scale(0.08f, 0.08f, sizeZ).brightness(15, 15).glowColor(GLOW_COLOR);
            border.addBlockDisplay("player_east", BORDER_MATERIAL).offset(sizeX, playerOffsetY, 0.0f).scale(0.08f, 0.08f, sizeZ).brightness(15, 15).glowColor(GLOW_COLOR);
        }
        border.show(player);
        Scheduler.runTaskLater(() -> {
            if (HoloManager.instance().exists(holoName)) {
                HoloManager.instance().remove(holoName);
            }
        }, 200L);
    }
}

