/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.member;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.commands.MemberCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.doos.PlayerDOO;
import cn.lunadeer.dominion.inputters.SearchPlayerInputter;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.dominion.manage.member.MemberList;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class SelectPlayer
extends AbstractUI {
    public static void show(CommandSender sender, String dominionName, String pageStr) {
        new SelectPlayer().displayByPreference(sender, dominionName, pageStr);
    }

    public static ListViewButton button(final Player player, final String dominionName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.selectPlayerTuiText.button){

            @Override
            public void function(String pageStr) {
                SelectPlayer.show((CommandSender)player, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission).setHoverText(TextUserInterface.selectPlayerTuiText.description);
    }

    @Override
    protected void showTUI(final Player player, String ... args) throws Exception {
        final String dominionName = args[0];
        String pageStr = args[1];
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionAdmin(player, dominion);
        int page = Converts.toIntegrity(pageStr);
        ListView view = ListView.create(10, SelectPlayer.button(player, dominionName));
        Line sub = Line.create().append(SearchPlayerInputter.createTuiButtonOn((CommandSender)player, dominionName).build()).append(MemberList.button((CommandSender)player, dominionName).setText(TextUserInterface.selectPlayerTuiText.back).build());
        view.title(TextUserInterface.selectPlayerTuiText.title).subtitle(sub);
        List<PlayerDTO> players = PlayerDOO.all();
        for (final PlayerDTO p : players) {
            view.add(Line.create().append(new FunctionalButton(p.getLastKnownName()){

                @Override
                public void function() {
                    MemberCommand.addMember((CommandSender)player, dominionName, p.getLastKnownName());
                }
            }.needPermission(Dominion.defaultPermission).build()));
        }
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final String dominionName = args[0];
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionAdmin(player, dominion);
        final ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.selectPlayerCui.title, dominion.getName()));
        view.applyListConfiguration(ChestUserInterface.selectPlayerCui.listConfiguration, Converts.toIntegrity(args[1]));
        view.setButton(ChestUserInterface.selectPlayerCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.selectPlayerCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MemberList.show((CommandSender)player, dominionName, "1");
            }
        });
        view.setButton(ChestUserInterface.selectPlayerCui.searchButton.getSymbol(), new ChestButton(ChestUserInterface.selectPlayerCui.searchButton){

            @Override
            public void onClick(ClickType type) {
                SearchPlayerInputter.createOn((CommandSender)player, dominionName);
                view.close();
            }
        });
        List<PlayerDTO> players = PlayerDOO.all();
        List<UUID> members = dominion.getMembers().stream().map(MemberDTO::getPlayerUUID).toList();
        for (final PlayerDTO p : players) {
            if (members.contains(p.getUuid())) continue;
            ButtonConfiguration playerButtonConfig = ButtonConfiguration.createHeadByName(ChestUserInterface.selectPlayerCui.listConfiguration.itemSymbol.charAt(0), p.getLastKnownName(), ChestUserInterface.selectPlayerCui.playerButtonName, ChestUserInterface.selectPlayerCui.playerButtonLore);
            ChestButton playerChest = new ChestButton(playerButtonConfig){

                @Override
                public void onClick(ClickType type) {
                    MemberCommand.addMember((CommandSender)player, dominionName, p.getLastKnownName());
                }
            }.setDisplayNameArgs(p.getLastKnownName()).setLoreArgs(p.getLastKnownName());
            view.addItem(playerChest);
        }
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
    }

    public static class SelectPlayerTuiText
    extends ConfigurationPart {
        public String title = "Select Player";
        public String button = "ADD PLAYER";
        public String description = "Add a player as a member of this dominion.";
        public String back = "BACK";
    }

    public static class SelectPlayerCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a75\u00a7lSelect Player for {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<######s#", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Member List", List.of("\u00a77Return to the member list", "\u00a77without adding a player.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration searchButton = ButtonConfiguration.createMaterial('s', Material.COMPASS, "\u00a7e\ud83d\udd0d \u00a76Search Player", List.of("\u00a77Search for a specific player", "\u00a77by entering their username.", "", "\u00a76\u25b6 Click to search", "", "\u00a78Useful for finding offline players!"));
        public String playerButtonName = "\u00a7a\u2795 \u00a72{0}";
        public List<String> playerButtonLore = List.of("\u00a77Add this player as a member", "\u00a77of your dominion.", "", "\u00a77Player: \u00a7e{0}", "", "\u00a72\u25b6 Click to add member");
    }
}

