/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.MigrationCommand;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.ResMigration;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class MigrateList
extends AbstractUI {
    public static SecondaryCommand migrateList = new SecondaryCommand("migrate_list", List.of(new CommandArguments.OptionalPageArgument()), Language.uiCommandsDescription.migrateList){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                MigrateList.show(sender, this.getArgumentValue(0));
            }
            catch (Exception e) {
                Notification.error(sender, e.getMessage());
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String pageStr) {
        new MigrateList().displayByPreference(sender, pageStr);
    }

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(TextUserInterface.migrateListTuiText.button){

            @Override
            public void function(String pageStr) {
                MigrateList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final Player player, String ... args) throws Exception {
        List<ResMigration.ResidenceNode> res_data;
        if (!Configuration.residenceMigration) {
            Notification.error((CommandSender)player, TextUserInterface.migrateListTuiText.notEnabled);
            return;
        }
        int page = Converts.toIntegrity(args[0], 1);
        ListView view = ListView.create(10, MigrateList.button((CommandSender)player));
        view.title(TextUserInterface.migrateListTuiText.title);
        view.navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(TextUserInterface.migrateListTuiText.button));
        if (player.hasPermission(Dominion.adminPermission)) {
            res_data = CacheManager.instance.getResidenceCache().getResidenceData();
            view.add(Line.create().append(new ListViewButton(TextUserInterface.migrateListTuiText.migrateAll){

                @Override
                public void function(String pageStr) {
                    MigrationCommand.migrateAll((CommandSender)player);
                }
            }.needPermission(Dominion.defaultPermission).build()));
        } else {
            res_data = CacheManager.instance.getResidenceCache().getResidenceData(player.getUniqueId());
        }
        if (res_data == null) {
            view.add(Line.create().append(TextUserInterface.migrateListTuiText.noData));
        } else {
            view.addLines(MigrateList.BuildTreeLines(player, res_data, 0, page));
        }
        view.showOn(player, page);
    }

    public static List<Line> BuildTreeLines(Player player, List<ResMigration.ResidenceNode> dominionTree, Integer depth, int page) {
        ArrayList<Line> lines = new ArrayList<Line>();
        StringBuilder prefix = new StringBuilder();
        prefix.append(" | ".repeat(Math.max(0, depth)));
        for (ResMigration.ResidenceNode node : dominionTree) {
            ListViewButton migrate = MigrationCommand.button((CommandSender)player, node.name);
            Line line = Line.create();
            if (depth == 0) {
                line.append(migrate.build());
            } else {
                line.append(migrate.setDisabled(TextUserInterface.migrateListTuiText.cantMigrate).build());
            }
            line.append(String.valueOf(prefix) + node.name);
            lines.add(line);
            lines.addAll(MigrateList.BuildTreeLines(player, node.children, depth + 1, page));
        }
        return lines;
    }

    @Override
    protected void showCUI(final Player player, final String ... args) throws Exception {
        if (!Configuration.residenceMigration) {
            Notification.error((CommandSender)player, TextUserInterface.migrateListTuiText.notEnabled);
            return;
        }
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(ChestUserInterface.migrateListCui.title);
        view.applyListConfiguration(ChestUserInterface.migrateListCui.listConfiguration, Converts.toIntegrity(args[0], 1));
        List<ResMigration.ResidenceNode> res_data = player.hasPermission(Dominion.adminPermission) ? CacheManager.instance.getResidenceCache().getResidenceData() : CacheManager.instance.getResidenceCache().getResidenceData(player.getUniqueId());
        if (res_data != null) {
            for (final ResMigration.ResidenceNode node : res_data) {
                ChestButton btn = new ChestButton(ChestUserInterface.migrateListCui.residenceItemButton){

                    @Override
                    public void onClick(ClickType type) {
                        MigrationCommand.migrate((CommandSender)player, node.name, args[0]);
                    }
                };
                btn = btn.setDisplayNameArgs(node.name);
                view = view.addItem(btn);
            }
        }
        if (player.hasPermission(Dominion.adminPermission)) {
            view.setButton(ChestUserInterface.migrateListCui.migrateAllButton.getSymbol(), new ChestButton(ChestUserInterface.migrateListCui.migrateAllButton){

                @Override
                public void onClick(ClickType type) {
                    MigrationCommand.migrateAll((CommandSender)player);
                }
            });
        }
        view.setButton(ChestUserInterface.migrateListCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.migrateListCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MainMenu.show((CommandSender)player, "1");
            }
        });
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
        if (!Configuration.residenceMigration) {
            Notification.error(sender, TextUserInterface.migrateListTuiText.notEnabled);
            return;
        }
        Notification.info(sender, ChestUserInterface.migrateListCui.title);
        Notification.info(sender, MigrationCommand.migrateAll.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, MigrationCommand.migrateAll.getDescription());
        Notification.info(sender, MigrationCommand.migrate.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, MigrationCommand.migrate.getDescription());
        List<ResMigration.ResidenceNode> res_data = CacheManager.instance.getResidenceCache().getResidenceData();
        int page = Converts.toIntegrity(args[0], 1);
        Triple<Integer, Integer, Integer> pageInfo = Misc.pageUtil(page, 15, res_data.size());
        for (int i = ((Integer)pageInfo.getLeft()).intValue(); i < (Integer)pageInfo.getMiddle(); ++i) {
            ResMigration.ResidenceNode node = res_data.get(i);
            Notification.info(sender, "\u00a76\ud83d\udccb \u00a7f{0} \u00a77(\u00a7b{1}\u00a77) ", node.name, node.ownerName);
        }
        Notification.info(sender, Language.consoleText.pageInfo, page, pageInfo.getRight(), res_data.size());
    }

    public static class MigrateListTuiText
    extends ConfigurationPart {
        public String title = "Migrate From Residence";
        public String description = "Migrate residence data to dominion.";
        public String button = "MIGRATE";
        public String notEnabled = "Residence migration is not enabled.";
        public String noData = "No data to migrate.";
        public String cantMigrate = "Sub-residence will be migrated with the parent.";
        public String migrateAll = "MIGRATE ALL";
    }

    public static class MigrateListCui
    extends ConfigurationPart {
        public String title = "\u00a76\u26a1 \u00a7c\u00a7lMigrate From Residence \u00a76\u26a1";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<######A#", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration residenceItemButton = ButtonConfiguration.createMaterial('i', Material.PAPER, "\u00a76\ud83d\udccb \u00a7f{0}", List.of("\u00a7e\u25b6 Click to migrate this residence", "\u00a78  and all its sub-residences"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Main Menu", List.of("\u00a77Return to the main menu", "\u00a78to access other features.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration migrateAllButton = ButtonConfiguration.createMaterial('A', Material.DIAMOND, "\u00a76\u26a1 \u00a7c\u00a7lMIGRATE ALL", List.of("\u00a7e\u25b6 Click to migrate all residences", "\u00a78  and all their sub-residences", "", "\u00a7c\u26a0\ufe0f This may take a while,", "\u00a7c\u26a0\ufe0f please be patient and do not", "\u00a7c\u26a0\ufe0f interrupt the process."));
    }
}

