/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.DominionAPI;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class AllDominionOfPlayer
extends AbstractUI {
    public static SecondaryCommand listAll = new SecondaryCommand("list_all_of", List.of(new CommandArguments.RequiredPlayerArgument(), new CommandArguments.OptionalPageArgument()), Language.uiCommandsDescription.listAllOfDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            AllDominionOfPlayer.show(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.adminPermission).register();

    public static void show(CommandSender sender, String playerNameStr, String pageStr) {
        new AllDominionOfPlayer().displayByPreference(sender, playerNameStr, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String playerNameStr) {
        return (ListViewButton)new ListViewButton(TextUserInterface.allDominionOfPlayerTuiText.button){

            @Override
            public void function(String pageStr) {
                AllDominionOfPlayer.show(sender, playerNameStr, pageStr);
            }
        }.needPermission(Dominion.adminPermission);
    }

    @Override
    protected void showTUI(Player sender, String ... args) {
        PlayerDTO playerDTO = Converts.toPlayerDTO(args[0]);
        int page = Converts.toIntegrity(args[1], 1);
        ListView view = ListView.create(10, AllDominionOfPlayer.button((CommandSender)sender, playerDTO.getLastKnownName()));
        view.title(TextUserInterface.allDominionOfPlayerTuiText.title);
        view.navigator(Line.create().append(MainMenu.button((CommandSender)sender).build()));
        view.addLines(DominionList.BuildTreeLines((CommandSender)sender, CacheManager.instance.getCache().getDominionCache().getPlayerDominionNodes(playerDTO.getUuid()), 0));
        view.showOn(sender, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) {
        PlayerDTO playerDTO = Converts.toPlayerDTO(args[0]);
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(ChestUserInterface.allDominionOfPlayerCui.title);
        view.applyListConfiguration(ChestUserInterface.allDominionOfPlayerCui.listConfiguration, Converts.toIntegrity(args[1]));
        List<DominionDTO> dominions = DominionAPI.getInstance().getAllDominionsOfPlayer(playerDTO.getUuid());
        for (final DominionDTO dominion : dominions) {
            ChestButton btn = new ChestButton(ChestUserInterface.allDominionCui.dominionItemButton){

                @Override
                public void onClick(ClickType type) {
                    if (type.isLeftClick()) {
                        DominionManage.show((CommandSender)player, dominion.getName(), "1");
                    } else if (type.isRightClick()) {
                        TeleportManager.teleportToDominion(player, dominion);
                    }
                }
            };
            btn = btn.setDisplayNameArgs(dominion.getName());
            btn = btn.setLoreArgs(List.of(dominion.getOwnerDTO().getLastKnownName()));
            view = view.addItem(btn);
        }
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
        PlayerDTO playerDTO = Converts.toPlayerDTO(args[0]);
        Notification.info(sender, ChestUserInterface.allDominionOfPlayerCui.title, playerDTO.getLastKnownName());
        Notification.info(sender, DominionManage.manage.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, DominionManage.manage.getDescription());
        List<DominionDTO> dominions = DominionAPI.getInstance().getAllDominionsOfPlayer(playerDTO.getUuid());
        int page = Converts.toIntegrity(args[1], 1);
        Triple<Integer, Integer, Integer> pageInfo = Misc.pageUtil(page, 15, dominions.size());
        for (int i = ((Integer)pageInfo.getLeft()).intValue(); i < (Integer)pageInfo.getMiddle(); ++i) {
            DominionDTO dominion = dominions.get(i);
            String ownerName = dominion.getOwnerDTO().getLastKnownName();
            Notification.info(sender, "\u00a76\u25b6 \u00a7e{0} \u00a77(\u00a7b{1}\u00a77) ", dominion.getName(), ownerName);
        }
        Notification.info(sender, Language.consoleText.pageInfo, page, pageInfo.getRight(), dominions.size());
    }

    public static class AllDominionOfPlayerTuiText
    extends ConfigurationPart {
        public String title = "All Dominions of {0}";
        public String button = "LIST ALL OF";
    }

    public static class AllDominionOfPlayerCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7c\u00a7lAll Dominions Of {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
    }
}

