/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.nms;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.nms.FakeEntityFactory;
import cn.lunadeer.dominion.nms.NMSPacketSender;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.XVersionManager;

public class NMSManager {
    private static NMSManager INSTANCE;
    private FakeEntityFactory fakeEntityFactory;
    private NMSPacketSender packetSender;

    private NMSManager() {
    }

    public static void initialize() {
        INSTANCE = new NMSManager();
        INSTANCE.loadImplementations();
    }

    public static NMSManager instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("NMSManager has not been initialized. Call NMSManager.initialize() first.");
        }
        return INSTANCE;
    }

    public FakeEntityFactory getFakeEntityFactory() {
        return this.fakeEntityFactory;
    }

    public NMSPacketSender getPacketSender() {
        return this.packetSender;
    }

    private void loadImplementations() {
        XVersionManager.ImplementationVersion version = XVersionManager.VERSION;
        if (version == null) {
            throw new RuntimeException("Server version not determined. Cannot load NMS implementations.");
        }
        String nmsPackage = "cn.lunadeer.dominion." + version.name() + ".nms";
        while (Misc.listClassOfPackage(Dominion.instance, nmsPackage).isEmpty()) {
            version = XVersionManager.VERSION.getPrevious();
            if (version == null) {
                throw new RuntimeException("No compatible NMS implementations found for server version " + XVersionManager.VERSION.name() + " or any previous versions.");
            }
            nmsPackage = "cn.lunadeer.dominion." + version.name() + ".nms";
        }
        nmsPackage = nmsPackage + ".";
        XLogger.debug("Loading NMS implementations from package: {0}", nmsPackage);
        try {
            Class<?> factoryClass = Class.forName(nmsPackage + "FakeEntityFactoryImpl");
            this.fakeEntityFactory = (FakeEntityFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            XLogger.debug("Loaded FakeEntityFactory: {0}", factoryClass.getName());
            Class<?> senderClass = Class.forName(nmsPackage + "NMSPacketSenderImpl");
            this.packetSender = (NMSPacketSender)senderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            XLogger.debug("Loaded NMSPacketSender: {0}", senderClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("NMS implementation not found for version " + version.name() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load NMS implementations for version " + version.name() + ": " + e.getMessage(), e);
        }
        XLogger.info("NMS implementations loaded for version: {0}", version.name());
    }
}

