/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.misc;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.events.dominion.modify.DominionReSizeEvent;
import cn.lunadeer.dominion.events.dominion.modify.DominionSetMessageEvent;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Converts {
    @NotNull
    public static Player toPlayer(@NotNull CommandSender sender) throws DominionException {
        if (sender instanceof Player) {
            return (Player)sender;
        }
        throw new DominionException(Language.convertsText.mustBePlayer, new Object[0]);
    }

    @NotNull
    public static Player toPlayer(UUID uuid) throws DominionException {
        Player player = Dominion.instance.getServer().getPlayer(uuid);
        if (player != null) {
            return player;
        }
        throw new DominionException(Language.convertsText.mustBeOnline, uuid.toString());
    }

    @NotNull
    public static Player toPlayer(@NotNull String name) throws DominionException {
        Player player = Dominion.instance.getServer().getPlayer(name);
        if (player != null) {
            return player;
        }
        throw new DominionException(Language.convertsText.mustBeOnline, name);
    }

    @NotNull
    public static World toWorld(@NotNull String name) throws DominionException {
        World world = Dominion.instance.getServer().getWorld(name);
        if (world != null) {
            return world;
        }
        throw new DominionException(Language.convertsText.worldNotExist, name);
    }

    @NotNull
    public static World toWorld(@NotNull UUID uuid) throws DominionException {
        World world = Dominion.instance.getServer().getWorld(uuid);
        if (world != null) {
            return world;
        }
        throw new DominionException(Language.convertsText.worldNotExist, uuid.toString());
    }

    @NotNull
    public static EnvFlag toEnvFlag(String flagName) throws DominionException {
        EnvFlag flag = Flags.getEnvFlag(flagName);
        if (flag == null) {
            throw new DominionException(Language.convertsText.unknownEnvFlag, flagName);
        }
        return flag;
    }

    @NotNull
    public static PriFlag toPriFlag(String flagName) throws DominionException {
        PriFlag flag = Flags.getPreFlag(flagName);
        if (flag == null) {
            throw new DominionException(Language.convertsText.unknownPreFlag, flagName);
        }
        return flag;
    }

    @NotNull
    public static DominionDTO toDominionDTO(@NotNull String name) throws DominionException {
        DominionDTO dominion = CacheManager.instance.getDominion(name);
        if (dominion != null) {
            return dominion;
        }
        throw new DominionException(Language.convertsText.unknownDominion, name);
    }

    @NotNull
    public static DominionDTO toDominionDTO(@NotNull Integer id) throws DominionException {
        DominionDTO dominion = CacheManager.instance.getDominion(id);
        if (dominion == null) {
            throw new DominionException(Language.convertsText.unknownDominion, id.toString());
        }
        return dominion;
    }

    public static int toIntegrity(String arg) throws DominionException {
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            throw new DominionException(Language.convertsText.invalidNumberFormat, arg);
        }
    }

    public static int toIntegrity(String arg, int defaultValue) {
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean toBoolean(String arg) throws DominionException {
        if (arg.toUpperCase().startsWith("T")) {
            return true;
        }
        if (arg.toUpperCase().startsWith("F")) {
            return false;
        }
        throw new DominionException(Language.convertsText.invalidBooleanFormat, arg);
    }

    public static Location[] getSelectedPoints(@NotNull Player player) throws DominionException {
        Map<Integer, Location> points = Dominion.pointsSelect.get(player.getUniqueId());
        if (points == null || points.size() != 2) {
            throw new DominionException(Language.convertsText.invalidPoints, new Object[0]);
        }
        if (!points.get(0).getWorld().getUID().equals(points.get(1).getWorld().getUID())) {
            throw new DominionException(Language.convertsText.invalidPoints, new Object[0]);
        }
        return Others.sortLocations(points.get(0), points.get(1));
    }

    public static DominionSetMessageEvent.TYPE toMessageType(String arg) {
        if (arg.toUpperCase().startsWith("E")) {
            return DominionSetMessageEvent.TYPE.ENTER;
        }
        if (arg.toUpperCase().startsWith("L")) {
            return DominionSetMessageEvent.TYPE.LEAVE;
        }
        throw new DominionException(Language.convertsText.unknownMessageType, arg);
    }

    public static DominionReSizeEvent.TYPE toResizeType(String arg) throws DominionException {
        if (arg.toUpperCase().startsWith("E")) {
            return DominionReSizeEvent.TYPE.EXPAND;
        }
        if (arg.toUpperCase().startsWith("C")) {
            return DominionReSizeEvent.TYPE.CONTRACT;
        }
        throw new DominionException(Language.convertsText.unknownResizeType, arg);
    }

    public static DominionReSizeEvent.DIRECTION toDirection(String arg) throws DominionException {
        if (arg.toUpperCase().startsWith("N")) {
            return DominionReSizeEvent.DIRECTION.NORTH;
        }
        if (arg.toUpperCase().startsWith("E")) {
            return DominionReSizeEvent.DIRECTION.EAST;
        }
        if (arg.toUpperCase().startsWith("S")) {
            return DominionReSizeEvent.DIRECTION.SOUTH;
        }
        if (arg.toUpperCase().startsWith("W")) {
            return DominionReSizeEvent.DIRECTION.WEST;
        }
        if (arg.toUpperCase().startsWith("U")) {
            return DominionReSizeEvent.DIRECTION.UP;
        }
        if (arg.toUpperCase().startsWith("D")) {
            return DominionReSizeEvent.DIRECTION.DOWN;
        }
        throw new DominionException(Language.convertsText.unknownBlockFace, arg);
    }

    public static DominionReSizeEvent.DIRECTION toDirection(Player player) {
        float yaw = player.getLocation().getYaw();
        float pitch = player.getLocation().getPitch();
        if (pitch > -45.0f && pitch < 45.0f) {
            if (yaw > -45.0f && yaw < 45.0f) {
                return DominionReSizeEvent.DIRECTION.SOUTH;
            }
            if (yaw > 135.0f || yaw < -135.0f) {
                return DominionReSizeEvent.DIRECTION.NORTH;
            }
            if (yaw > 45.0f && yaw < 135.0f) {
                return DominionReSizeEvent.DIRECTION.WEST;
            }
            return DominionReSizeEvent.DIRECTION.EAST;
        }
        if (pitch > 45.0f) {
            return DominionReSizeEvent.DIRECTION.DOWN;
        }
        return DominionReSizeEvent.DIRECTION.UP;
    }

    public static Color toColor(String arg) throws DominionException {
        if (arg.startsWith("0x")) {
            try {
                int color = Integer.parseInt(arg.substring(2), 16);
                return Color.fromRGB((int)color);
            }
            catch (NumberFormatException e) {
                throw new DominionException(Language.convertsText.invalidColorFormat, arg);
            }
        }
        throw new DominionException(Language.convertsText.invalidColorFormat, arg);
    }

    public static PlayerDTO toPlayerDTO(String name) throws DominionException {
        PlayerDTO playerDTO = CacheManager.instance.getPlayer(name);
        if (playerDTO == null) {
            throw new DominionException(Language.convertsText.unknownPlayer, name);
        }
        return playerDTO;
    }

    public static PlayerDTO toPlayerDTO(UUID uuid) {
        PlayerDTO playerDTO = CacheManager.instance.getPlayer(uuid);
        if (playerDTO == null) {
            throw new DominionException(Language.convertsText.unknownPlayer, uuid.toString());
        }
        return playerDTO;
    }

    @NotNull
    public static MemberDTO toMemberDTO(@NotNull DominionDTO dominion, String playerName) {
        PlayerDTO player = Converts.toPlayerDTO(playerName);
        MemberDTO member = CacheManager.instance.getMember(dominion, player.getUuid());
        if (member != null) {
            return member;
        }
        throw new DominionException(Language.convertsText.notMember, playerName, dominion.getName());
    }

    @NotNull
    public static GroupDTO toGroupDTO(@NotNull DominionDTO dominion, String groupName) {
        GroupDTO group = dominion.getGroups().stream().filter(g -> g.getNamePlain().equals(groupName)).findFirst().orElse(null);
        if (group != null) {
            return group;
        }
        throw new DominionException(Language.convertsText.noGroupFound, groupName, dominion.getName());
    }

    @NotNull
    public static GroupDTO toGroupDTO(@NotNull Integer groupId) {
        GroupDTO group = CacheManager.instance.getGroup(groupId);
        if (group != null) {
            return group;
        }
        throw new DominionException(Language.convertsText.noGroupFound, groupId.toString());
    }

    public static class ConvertsText
    extends ConfigurationPart {
        public String mustBePlayer = "Must be a player for this command/operation.";
        public String mustBeOnline = "The player ({0}) must be online.";
        public String worldNotExist = "The world ({0}) does not exist.";
        public String unknownEnvFlag = "Unknown environment flag: {0}.";
        public String unknownPreFlag = "Unknown privilege flag: {0}.";
        public String unknownDominion = "Unknown dominion: {0}.";
        public String invalidNumberFormat = "Invalid number of arguments: {0}.";
        public String invalidBooleanFormat = "Invalid boolean value of arguments: {0}, should be true or false.";
        public String invalidPoints = "You need to select two points in the same world to create a dominion.";
        public String unknownBlockFace = "Unknown direction: {0}.";
        public String unknownResizeType = "Unknown resize type: {0}.";
        public String unknownMessageType = "Unknown message type: {0}.";
        public String invalidColorFormat = "Invalid color value of arguments: {0}, should be a hex color value (0xRRGGBB).";
        public String unknownPlayer = "Player {0} have not been recorded (after the plugin is installed).";
        public String notMember = "Player {0} is not a member of dominion {1}.";
        public String noGroupFound = "No group found with the name {0} in dominion {1}.";
    }
}

