/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.doos;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import cn.lunadeer.dominion.utils.databse.FIelds.FieldBoolean;
import cn.lunadeer.dominion.utils.databse.FIelds.FieldInteger;
import cn.lunadeer.dominion.utils.databse.FIelds.FieldString;
import cn.lunadeer.dominion.utils.databse.syntax.Delete;
import cn.lunadeer.dominion.utils.databse.syntax.Insert;
import cn.lunadeer.dominion.utils.databse.syntax.Select;
import cn.lunadeer.dominion.utils.databse.syntax.Update;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DominionDOO
implements DominionDTO {
    private DominionCuboid cuboid;
    private final FieldInteger id = new FieldInteger("id");
    private final FieldString owner = new FieldString("owner");
    private final FieldString name = new FieldString("name");
    private final FieldInteger parentDomId = new FieldInteger("parent_dom_id", -1);
    private final FieldString joinMessage = new FieldString("join_message", "");
    private final FieldString leaveMessage = new FieldString("leave_message", "");
    private final Map<EnvFlag, Boolean> envFlags = new HashMap<EnvFlag, Boolean>();
    private final Map<PriFlag, Boolean> preFlags = new HashMap<PriFlag, Boolean>();
    private final FieldString tp_location = new FieldString("tp_location", "default");
    private final FieldString color = new FieldString("color", "#00BFFF");
    private final FieldString world_uid = new FieldString("world_uid");
    private final FieldInteger serverId = new FieldInteger("server_id");
    private UUID cachedWorldUid = null;

    private static Field<?>[] fields() {
        Field[] fields = new Field[12 + Flags.getAllEnvFlagsEnable().size() + Flags.getAllPriFlagsEnable().size() + 4];
        fields[0] = DominionDOO.rootDominion().cuboid.x1Field();
        fields[1] = DominionDOO.rootDominion().cuboid.y1Field();
        fields[2] = DominionDOO.rootDominion().cuboid.z1Field();
        fields[3] = DominionDOO.rootDominion().cuboid.x2Field();
        fields[4] = DominionDOO.rootDominion().cuboid.y2Field();
        fields[5] = DominionDOO.rootDominion().cuboid.z2Field();
        fields[6] = DominionDOO.rootDominion().id;
        fields[7] = DominionDOO.rootDominion().owner;
        fields[8] = DominionDOO.rootDominion().name;
        fields[9] = DominionDOO.rootDominion().world_uid;
        fields[10] = DominionDOO.rootDominion().parentDomId;
        fields[11] = DominionDOO.rootDominion().joinMessage;
        fields[12] = DominionDOO.rootDominion().leaveMessage;
        int i = 13;
        for (Flag flag : Flags.getAllEnvFlagsEnable()) {
            fields[i++] = new FieldBoolean(flag.getFlagName(), flag.getDefaultValue());
        }
        for (Flag flag : Flags.getAllPriFlagsEnable()) {
            fields[i++] = new FieldBoolean(flag.getFlagName(), flag.getDefaultValue());
        }
        fields[i++] = DominionDOO.rootDominion().tp_location;
        fields[i++] = DominionDOO.rootDominion().color;
        fields[i++] = DominionDOO.rootDominion().serverId;
        return fields;
    }

    private static DominionDOO parse(Map<String, Field<?>> map) {
        DominionCuboid cuboid = new DominionCuboid((Integer)map.get("x1").getValue(), (Integer)map.get("y1").getValue(), (Integer)map.get("z1").getValue(), (Integer)map.get("x2").getValue(), (Integer)map.get("y2").getValue(), (Integer)map.get("z2").getValue());
        HashMap<EnvFlag, Boolean> envFlags = new HashMap<EnvFlag, Boolean>();
        for (EnvFlag f : Flags.getAllEnvFlagsEnable()) {
            envFlags.put(f, (Boolean)map.get(f.getFlagName()).getValue());
        }
        HashMap<PriFlag, Boolean> preFlags = new HashMap<PriFlag, Boolean>();
        for (PriFlag f : Flags.getAllPriFlagsEnable()) {
            preFlags.put(f, (Boolean)map.get(f.getFlagName()).getValue());
        }
        return new DominionDOO((Integer)map.get("id").getValue(), UUID.fromString((String)map.get("owner").getValue()), (String)map.get("name").getValue(), UUID.fromString((String)map.get("world_uid").getValue()), cuboid, (Integer)map.get("parent_dom_id").getValue(), (String)map.get("join_message").getValue(), (String)map.get("leave_message").getValue(), envFlags, preFlags, (String)map.get("tp_location").getValue(), (String)map.get("color").getValue(), (Integer)map.get("server_id").getValue());
    }

    public static List<DominionDOO> selectAll(Integer serverId) throws SQLException {
        List<Map<String, Field<?>>> res = Select.select(DominionDOO.fields()).from("dominion").where("server_id = ? AND id >= 0", serverId).execute();
        return res.stream().map(DominionDOO::parse).toList();
    }

    public static DominionDOO rootDominion() {
        return new DominionDOO(-1, UUID.fromString("00000000-0000-0000-0000-000000000000"), "\u6839\u9886\u5730", UUID.fromString("00000000-0000-0000-0000-000000000000"), new DominionCuboid(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), -1, "null", "null", new HashMap<EnvFlag, Boolean>(), new HashMap<PriFlag, Boolean>(), "default", "#00BFFF", -1);
    }

    @Nullable
    public static DominionDOO select(Integer id) throws SQLException {
        if (id == -1) {
            return DominionDOO.rootDominion();
        }
        List<Map<String, Field<?>>> res = Select.select(DominionDOO.fields()).from("dominion").where("id = ?", id).execute();
        if (res.isEmpty()) {
            return null;
        }
        return DominionDOO.parse(res.get(0));
    }

    @Nullable
    public static DominionDOO select(String name) throws SQLException {
        List<Map<String, Field<?>>> res = Select.select(DominionDOO.fields()).from("dominion").where("name = ?", name).execute();
        if (res.isEmpty()) {
            return null;
        }
        return DominionDOO.parse(res.get(0));
    }

    @NotNull
    public static DominionDOO insert(DominionDOO dominion) throws SQLException {
        Map<String, Field<?>> res = Insert.insert().into("dominion").values(dominion.owner, dominion.name, dominion.world_uid, dominion.cuboid.x1Field(), dominion.cuboid.y1Field(), dominion.cuboid.z1Field(), dominion.cuboid.x2Field(), dominion.cuboid.y2Field(), dominion.cuboid.z2Field(), dominion.parentDomId, dominion.joinMessage, dominion.leaveMessage, dominion.tp_location, dominion.serverId).returning(DominionDOO.fields()).execute();
        if (res.isEmpty()) {
            throw new SQLException("Failed to insert dominion.");
        }
        DominionDOO inserted = DominionDOO.parse(res);
        CacheManager.instance.getCache().getDominionCache().load(inserted.getId());
        return inserted;
    }

    public static void deleteById(Integer dominion) throws SQLException {
        Delete.delete().from("dominion").where("id = ?", dominion).execute();
        CacheManager.instance.getCache().getDominionCache().delete(dominion);
    }

    private DominionDOO(Integer id, UUID owner, String name, UUID world_uid, DominionCuboid cuboid, Integer parentDomId, String joinMessage, String leaveMessage, Map<EnvFlag, Boolean> envFlags, Map<PriFlag, Boolean> preFlags, String tp_location, String color, Integer serverId) {
        this.id.setValue(id);
        this.owner.setValue(owner.toString());
        this.name.setValue(name);
        this.world_uid.setValue(world_uid.toString());
        this.cuboid = cuboid;
        this.parentDomId.setValue(parentDomId);
        this.joinMessage.setValue(joinMessage);
        this.leaveMessage.setValue(leaveMessage);
        this.envFlags.putAll(envFlags);
        this.preFlags.putAll(preFlags);
        this.tp_location.setValue(tp_location);
        this.color.setValue(color);
        this.serverId.setValue(serverId);
    }

    public DominionDOO(@NotNull UUID owner, @NotNull String name, @NotNull UUID world_uid, @NotNull CuboidDTO cuboid, @NotNull Integer parentDomId) {
        this.owner.setValue(owner.toString());
        this.name.setValue(name);
        this.world_uid.setValue(world_uid.toString());
        this.cuboid = new DominionCuboid(cuboid);
        this.parentDomId.setValue(parentDomId);
        this.joinMessage.setValue(Configuration.pluginMessage.defaultEnterMessage);
        this.leaveMessage.setValue(Configuration.pluginMessage.defaultLeaveMessage);
        this.serverId.setValue(Configuration.multiServer.serverId);
    }

    @Override
    @NotNull
    public Integer getId() {
        return this.id.getValue();
    }

    @NotNull
    public DominionDOO setId(Integer id) {
        this.id.setValue(id);
        return this;
    }

    @Override
    @NotNull
    public UUID getOwner() {
        return UUID.fromString(this.owner.getValue());
    }

    @Override
    @NotNull
    public PlayerDTO getOwnerDTO() {
        return Objects.requireNonNull(CacheManager.instance.getPlayer(this.getOwner()));
    }

    @Override
    @NotNull
    public DominionDOO setOwner(UUID owner) throws SQLException {
        this.owner.setValue(owner.toString());
        Update.update("dominion").set(this.owner).where("id = ?", this.id.getValue()).execute();
        CacheManager.instance.getCache().getDominionCache().load();
        return this;
    }

    @Override
    @NotNull
    public DominionDOO setOwner(Player owner) throws SQLException {
        return this.setOwner(owner.getUniqueId());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name.getValue();
    }

    @Override
    @NotNull
    public DominionDOO setName(String name) throws SQLException {
        String oldName = this.name.getValue();
        this.name.setValue(name);
        Update.update("dominion").set(this.name).where("id = ?", this.id.getValue()).execute();
        CacheManager.instance.getCache().getDominionCache().dominionNameUpdate(oldName, name, this.getId());
        return this;
    }

    @Override
    @Nullable
    public World getWorld() {
        return Dominion.instance.getServer().getWorld(this.getWorldUid());
    }

    @Override
    @NotNull
    public UUID getWorldUid() {
        if (this.cachedWorldUid == null) {
            this.cachedWorldUid = UUID.fromString(this.world_uid.getValue());
        }
        return this.cachedWorldUid;
    }

    @Override
    @NotNull
    public CuboidDTO getCuboid() {
        return this.cuboid;
    }

    @Override
    @NotNull
    public DominionDOO setCuboid(@NotNull CuboidDTO cuboid) throws SQLException {
        this.cuboid = new DominionCuboid(cuboid);
        Update.update("dominion").set(this.cuboid.x1Field(), this.cuboid.y1Field(), this.cuboid.z1Field(), this.cuboid.x2Field(), this.cuboid.y2Field(), this.cuboid.z2Field()).where("id = ?", this.id.getValue()).execute();
        CacheManager.instance.getCache().getDominionCache().load(this.getId());
        return this;
    }

    @Override
    @NotNull
    public Integer getParentDomId() {
        return this.parentDomId.getValue();
    }

    @Override
    @NotNull
    public String getJoinMessage() {
        return this.joinMessage.getValue();
    }

    @Override
    @NotNull
    public DominionDOO setJoinMessage(String joinMessage) throws SQLException {
        this.joinMessage.setValue(joinMessage);
        Update.update("dominion").set(this.joinMessage).where("id = ?", this.id.getValue()).execute();
        return this;
    }

    @Override
    @NotNull
    public String getLeaveMessage() {
        return this.leaveMessage.getValue();
    }

    @Override
    @NotNull
    public DominionDOO setLeaveMessage(String leaveMessage) throws SQLException {
        this.leaveMessage.setValue(leaveMessage);
        Update.update("dominion").set(this.leaveMessage).where("id = ?", this.id.getValue()).execute();
        return this;
    }

    @Override
    @NotNull
    public Map<EnvFlag, Boolean> getEnvironmentFlagValue() {
        return this.envFlags;
    }

    @Override
    public boolean getEnvFlagValue(@NotNull EnvFlag flag) {
        return this.envFlags.getOrDefault(flag, false);
    }

    @Override
    @NotNull
    public Map<PriFlag, Boolean> getGuestPrivilegeFlagValue() {
        return this.preFlags;
    }

    @Override
    public boolean getGuestFlagValue(@NotNull PriFlag flag) {
        if (this.preFlags.equals(Flags.ADMIN)) {
            return false;
        }
        return this.preFlags.getOrDefault(flag, false);
    }

    @Override
    @NotNull
    public DominionDOO setEnvFlagValue(@NotNull EnvFlag flag, @NotNull Boolean value) throws SQLException {
        this.envFlags.put(flag, value);
        FieldBoolean flagField = new FieldBoolean(flag.getFlagName(), value);
        Update.update("dominion").set(flagField).where("id = ?", this.id.getValue()).execute();
        return this;
    }

    @Override
    @NotNull
    public DominionDOO setGuestFlagValue(@NotNull PriFlag flag, @NotNull Boolean value) throws SQLException {
        this.preFlags.put(flag, value);
        FieldBoolean flagField = new FieldBoolean(flag.getFlagName(), value);
        Update.update("dominion").set(flagField).where("id = ?", this.id.getValue()).execute();
        return this;
    }

    @Override
    @NotNull
    public Location getTpLocation() {
        if (Objects.equals(this.tp_location.getValue(), "default")) {
            return new Location(this.getWorld(), (double)(this.cuboid.x1() + this.cuboid.x2()) / 2.0, (double)(this.cuboid.y1() + this.cuboid.y2()) / 2.0, (double)(this.cuboid.z1() + this.cuboid.z2()) / 2.0);
        }
        String[] loc = this.tp_location.getValue().split(":");
        World w = this.getWorld();
        if (loc.length == 3 && w != null) {
            return new Location(w, (double)Integer.parseInt(loc[0]), (double)Integer.parseInt(loc[1]), (double)Integer.parseInt(loc[2]));
        }
        if (loc.length == 5 && w != null) {
            return new Location(w, (double)Integer.parseInt(loc[0]), (double)Integer.parseInt(loc[1]), (double)Integer.parseInt(loc[2]), Float.parseFloat(loc[3]), Float.parseFloat(loc[4]));
        }
        return new Location(this.getWorld(), (double)(this.cuboid.x1() + this.cuboid.x2()) / 2.0, (double)(this.cuboid.y1() + this.cuboid.y2()) / 2.0, (double)(this.cuboid.z1() + this.cuboid.z2()) / 2.0);
    }

    @Override
    @NotNull
    public DominionDOO setTpLocation(Location loc) throws SQLException {
        this.tp_location.setValue(loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ() + ":" + loc.getYaw() + ":" + loc.getPitch());
        Update.update("dominion").set(this.tp_location).where("id = ?", this.id.getValue()).execute();
        return this;
    }

    @Override
    @NotNull
    public DominionDOO setColor(@NotNull Color color) throws SQLException {
        this.color.setValue(String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
        Update.update("dominion").set(this.color).where("id = ?", this.id.getValue()).execute();
        return this;
    }

    @Override
    public List<GroupDTO> getGroups() {
        return Objects.requireNonNull(CacheManager.instance.getCache(this.getServerId())).getGroupCache().getDominionGroups(this);
    }

    @Override
    public List<MemberDTO> getMembers() {
        return Objects.requireNonNull(CacheManager.instance.getCache(this.getServerId())).getMemberCache().getDominionMembers(this);
    }

    @Override
    public Integer getServerId() {
        return this.serverId.getValue();
    }

    @Override
    public int getColorR() {
        return Integer.valueOf(this.getColor().substring(1, 3), 16);
    }

    @Override
    public int getColorG() {
        return Integer.valueOf(this.getColor().substring(3, 5), 16);
    }

    @Override
    public int getColorB() {
        return Integer.valueOf(this.getColor().substring(5, 7), 16);
    }

    @Override
    @NotNull
    public String getColor() {
        return this.color.getValue();
    }

    @Override
    public int getColorHex() {
        return (this.getColorR() << 16) + (this.getColorG() << 8) + this.getColorB();
    }

    public static void deleteByPlayerUuid(UUID playerUUID) throws SQLException {
        Delete.delete().from("dominion").where("owner = ?", playerUUID.toString()).execute();
    }

    private static class DominionCuboid
    extends CuboidDTO {
        public DominionCuboid(int x1, int y1, int z1, int x2, int y2, int z2) {
            super(x1, y1, z1, x2, y2, z2);
        }

        public DominionCuboid(CuboidDTO superObj) {
            super(superObj.x1(), superObj.y1(), superObj.z1(), superObj.x2(), superObj.y2(), superObj.z2());
        }

        public DominionCuboid(ResultSet rs) throws SQLException {
            super(rs.getInt("x1"), rs.getInt("y1"), rs.getInt("z1"), rs.getInt("x2"), rs.getInt("y2"), rs.getInt("z2"));
        }

        public FieldInteger x1Field() {
            return new FieldInteger("x1", this.x1());
        }

        public FieldInteger y1Field() {
            return new FieldInteger("y1", this.y1());
        }

        public FieldInteger z1Field() {
            return new FieldInteger("z1", this.z1());
        }

        public FieldInteger x2Field() {
            return new FieldInteger("x2", this.x2());
        }

        public FieldInteger y2Field() {
            return new FieldInteger("y2", this.y2());
        }

        public FieldInteger z2Field() {
            return new FieldInteger("z2", this.z2());
        }
    }
}

