/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.configuration;

import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.Comments;
import cn.lunadeer.dominion.utils.configuration.ConfigurationFile;
import cn.lunadeer.dominion.utils.configuration.ConfigurationManager;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.configuration.HandleManually;
import cn.lunadeer.dominion.utils.configuration.Headers;
import cn.lunadeer.dominion.utils.configuration.PostProcess;
import cn.lunadeer.dominion.utils.configuration.PreProcess;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Headers(value={"This file controls how player can using the dominion feature.", "For more information, please visit:", "https://dominion.lunadeer.cn/en/notes/doc/owner/config-ref/limitations/"})
public class Limitation
extends ConfigurationFile {
    @Comments(value={"Do not modify this value."})
    public static int version = 2;
    @Comments(value={"The priority of group when player has multiple groups.", "The group with higher number will be used first."})
    public int priority = 0;
    @Comments(value={"The settings of the economy support.", "You need to install vault and a economy plugin to use this feature."})
    public Economy economy = new Economy();
    @Comments(value={"The settings of the teleportation feature."})
    public Teleportation teleportation = new Teleportation();
    @Comments(value={"How many dominions a player can create all over the world.", "Set -1 means no limitation."})
    public int amountAllOverTheWorld = 10;
    @Comments(value={"Whether sub dominions are not counted in the amount limitation."})
    public boolean doNotCountSubs = false;
    @HandleManually
    public Map<String, WorldLimitationSetting> worldLimitations = new HashMap<String, WorldLimitationSetting>();
    @HandleManually
    private final String worldLimitationsKey = "world-limitations";

    @PreProcess
    public void checkWorldLimitationSettings() {
        this.worldLimitations.put("default", new WorldLimitationSetting());
        if (!this.getYaml().contains("world-limitations")) {
            this.getYaml().createSection("world-limitations");
            this.getYaml().setComments("world-limitations", List.of("The settings of the limitations for each world.", "The default settings will be used if the world is not listed here.", "Do not delete the default."));
        }
    }

    @PostProcess(priority=1)
    public void loadWorldLimitationSettings() {
        XLogger.info(Language.limitationText.loadingWorldSettings);
        ConfigurationSection section = this.getYaml().getConfigurationSection("world-limitations");
        if (section == null) {
            return;
        }
        Set keys = section.getKeys(false);
        for (String key : keys) {
            XLogger.info(Language.limitationText.loadingWorldSetting, key);
            try {
                WorldLimitationSetting settings = new WorldLimitationSetting();
                ConfigurationManager.readConfigurationPart((ConfigurationSection)this.getYaml(), settings, "world-limitations." + key);
                this.worldLimitations.put(key, settings);
            }
            catch (Exception e) {
                XLogger.error(Language.limitationText.loadWorldSettingFailed, key, e.getMessage());
            }
        }
        XLogger.info(Language.limitationText.loadWorldSettingsSuccess, this.worldLimitations.size(), String.join((CharSequence)", ", this.worldLimitations.keySet()));
    }

    @PostProcess(priority=2)
    public void checkLimitationParams() {
        if (this.economy.pricePerBlock < 0.0) {
            this.economy.pricePerBlock = 0.0;
        }
        if (this.economy.refundRate < 0.0) {
            this.economy.refundRate = 0.0;
        } else if (this.economy.refundRate > 1.0) {
            this.economy.refundRate = 1.0;
        }
        if (this.amountAllOverTheWorld < 0) {
            this.amountAllOverTheWorld = -1;
        }
        if (this.worldLimitations.get("default") == null) {
            this.worldLimitations.put("default", new WorldLimitationSetting());
        }
        for (WorldLimitationSetting setting : this.worldLimitations.values()) {
            if (setting.amount < 0) {
                setting.amount = -1;
            }
            if (setting.amount > this.amountAllOverTheWorld && this.amountAllOverTheWorld != -1) {
                setting.amount = this.amountAllOverTheWorld;
            }
            if (setting.maxSubDominionDepth < 0) {
                setting.maxSubDominionDepth = -1;
            }
            if (setting.noHigherThan <= setting.noLowerThan) {
                setting.noHigherThan = setting.noLowerThan + 1;
            }
            if (setting.sizeMaxX < 0) {
                setting.sizeMaxX = -1;
            }
            if (setting.sizeMaxY < 0) {
                setting.sizeMaxY = -1;
            }
            if (setting.sizeMaxZ < 0) {
                setting.sizeMaxZ = -1;
            }
            if (setting.sizeMinX <= 0) {
                setting.sizeMinX = 1;
            }
            if (setting.sizeMaxX < setting.sizeMinX && setting.sizeMaxX != -1) {
                setting.sizeMaxX = setting.sizeMinX + 1;
            }
            if (setting.sizeMinY <= 0) {
                setting.sizeMinY = 1;
            }
            if (setting.sizeMaxY < setting.sizeMinY && setting.sizeMaxY != -1) {
                setting.sizeMaxY = setting.sizeMinY + 1;
            }
            if (setting.sizeMinZ <= 0) {
                setting.sizeMinZ = 1;
            }
            if (setting.sizeMaxZ >= setting.sizeMinZ || setting.sizeMaxZ == -1) continue;
            setting.sizeMaxZ = setting.sizeMinZ + 1;
        }
    }

    @PostProcess(priority=3)
    public void saveWorldLimitationSettings() {
        for (Map.Entry<String, WorldLimitationSetting> entry : this.worldLimitations.entrySet()) {
            try {
                String prefix = "world-limitations." + entry.getKey();
                ConfigurationManager.writeConfigurationPart((ConfigurationSection)this.getYaml(), entry.getValue(), prefix, !Objects.equals(entry.getKey(), "default"));
            }
            catch (Exception e) {
                XLogger.warn("Failed to save world limitation settings for world {0}", entry.getKey());
            }
        }
    }

    @NotNull
    public WorldLimitationSetting getWorldSettings(@NotNull UUID worldUUID) {
        return this.getWorldSettings(Converts.toWorld(worldUUID).getName());
    }

    @NotNull
    public WorldLimitationSetting getWorldSettings(@NotNull World world) {
        return this.getWorldSettings(world.getName());
    }

    @NotNull
    public WorldLimitationSetting getWorldSettings(@Nullable String worldName) {
        return this.worldLimitations.getOrDefault(worldName, this.worldLimitations.get("default"));
    }

    public static class Economy
    extends ConfigurationPart {
        public boolean enable = false;
        @Comments(value={"The price per block to claim dominion."})
        public double pricePerBlock = 10.0;
        @Comments(value={"Only count the square blocks, ignore the height."})
        public boolean squareOnly = false;
        @Comments(value={"The refund rate when player contract or delete dominion."})
        public double refundRate = 0.85;
        @Comments(value={"Whether free to create sub dominions."})
        public boolean freeForSubs = false;
    }

    public static class Teleportation
    extends ConfigurationPart {
        @Comments(value={"Enable the teleportation feature."})
        public boolean enable = true;
        @Comments(value={"The cooldown time of teleportation in seconds. 0 means no cooldown."})
        public int cooldown = 10;
        @Comments(value={"Delay time before teleportation in seconds. 0 means no delay."})
        public int delay = 5;
    }

    public static class WorldLimitationSetting
    extends ConfigurationPart {
        @Comments(value={"The maximum amount of dominions a player can create in this world.", "Set -1 means no limitation (but still limited by amount-all-over-the-world)."})
        public int amount = 5;
        @Comments(value={"The depth limit of sub dominion.", "Set to -1 means no limitation, 0 means no sub dominion."})
        public int maxSubDominionDepth = 3;
        @Comments(value={"Dominion's top no higher than this value.", "Should be larger than no-lower-than."})
        public int noHigherThan = 320;
        @Comments(value={"Dominion's bottom no lower than this value.", "Should be smaller than no-higher-than."})
        public int noLowerThan = -64;
        @Comments(value={"The maximum size of dominion in X axis (East-West).", "Set -1 means no limitation. Should be larger than size-min-x and 0."})
        public int sizeMaxX = 128;
        @Comments(value={"The maximum size of dominion in Y axis (Height).", "Set -1 means no limitation. Should be larger than size-min-y and 0."})
        public int sizeMaxY = 64;
        @Comments(value={"The maximum size of dominion in Z axis (North-South).", "Set -1 means no limitation. Should be larger than size-min-z and 0."})
        public int sizeMaxZ = 128;
        @Comments(value={"The minimum size of dominion in X axis (East-West).", "Should be smaller than size-max-x and larger than 0."})
        public int sizeMinX = 4;
        @Comments(value={"The minimum size of dominion in Y axis (Height).", "Should be smaller than size-max-y and larger than 0."})
        public int sizeMinY = 4;
        @Comments(value={"The minimum size of dominion in Z axis (North-South).", "Should be smaller than size-max-z and larger than 0."})
        public int sizeMinZ = 4;
        @Comments(value={"Weather to include all vertical blocks when calculating the size."})
        public boolean autoIncludeVertical = false;
    }

    public static class LimitationText
    extends ConfigurationPart {
        public String loadingWorldSettings = "Loading world-settings...";
        public String loadingWorldSetting = "Loading world-settings of {0}...";
        public String loadWorldSettingFailed = "Failed to world-settings of {0} reason: {1}";
        public String loadWorldSettingsSuccess = "Successfully loaded {0} world-settings: {1}.";
    }
}

