/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.doos.TemplateDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.uis.template.TemplateFlags;
import cn.lunadeer.dominion.uis.template.TemplateList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TemplateCommand {
    public static SecondaryCommand createTemplate = new SecondaryCommand("template_create", (List)List.of(new Argument("template_name", true)), Language.templateCommandText.createTemplateDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            TemplateCommand.createTemplate(sender, this.getArgumentValue(0));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand deleteTemplate = new SecondaryCommand("template_delete", List.of(new CommandArguments.RequiredTemplateArgument(), new CommandArguments.OptionalPageArgument()), Language.templateCommandText.deleteTemplateDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            TemplateCommand.deleteTemplate(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setTemplateFlag = new SecondaryCommand("template_set_flag", List.of(new CommandArguments.RequiredTemplateArgument(), new CommandArguments.PriFlagArgument(), new CommandArguments.BollenOption(), new CommandArguments.OptionalPageArgument()), Language.templateCommandText.setTemplateFlagDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            TemplateCommand.setTemplateFlag(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand memberApplyTemplate = new SecondaryCommand("member_apply_template", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredMemberArgument(0), new CommandArguments.RequiredTemplateArgument()), Language.templateCommandText.memberApplyTemplateDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            TemplateCommand.memberApplyTemplate(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand renameTemplate = new SecondaryCommand("template_rename", List.of(new CommandArguments.RequiredTemplateArgument(), new Argument("new_name", true), new CommandArguments.OptionalPageArgument()), Language.templateCommandText.renameTemplateDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            TemplateCommand.renameTemplate(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void createTemplate(CommandSender sender, String templateName) {
        try {
            Player player = Converts.toPlayer(sender);
            if (templateName.contains(" ")) {
                throw new DominionException(Language.templateCommandText.nameNotValid, new Object[0]);
            }
            List<TemplateDOO> templates = TemplateDOO.selectAll(player.getUniqueId());
            if (templates.stream().anyMatch(t -> t.getName().equals(templateName))) {
                throw new DominionException(Language.templateCommandText.templateNameExist, templateName);
            }
            TemplateDOO.create(player.getUniqueId(), templateName);
            Notification.info(sender, Language.templateCommandText.createTemplateSuccess, templateName);
            TemplateList.show(sender, "1");
        }
        catch (Exception e) {
            Notification.error(sender, Language.templateCommandText.createTemplateFail, e.getMessage());
        }
    }

    public static void deleteTemplate(CommandSender sender, String templateName, String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            TemplateDOO template = TemplateDOO.select(player.getUniqueId(), templateName);
            if (template == null) {
                throw new DominionException(Language.templateCommandText.templateNotExist, templateName);
            }
            TemplateDOO.delete(player.getUniqueId(), templateName);
            Notification.info(sender, Language.templateCommandText.deleteTemplateSuccess, templateName);
            TemplateList.show(sender, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, Language.templateCommandText.deleteTemplateFail, e.getMessage());
        }
    }

    public static void setTemplateFlag(CommandSender sender, String templateName, String flagName, String valueStr, String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            boolean value = Converts.toBoolean(valueStr);
            PriFlag flag = Converts.toPriFlag(flagName);
            TemplateDOO template = TemplateDOO.select(player.getUniqueId(), templateName);
            if (template == null) {
                throw new DominionException(Language.templateCommandText.templateNotExist, templateName);
            }
            template.setFlagValue(flag, value);
            Notification.info(sender, Language.templateCommandText.setFlagSuccess, flagName, templateName, valueStr);
            TemplateFlags.show(sender, templateName, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, Language.templateCommandText.setFlagFail, e.getMessage());
        }
    }

    public static void memberApplyTemplate(CommandSender sender, String dominionName, String playerName, String templateName) {
        try {
            Player player = Converts.toPlayer(sender);
            TemplateDOO template = TemplateDOO.select(player.getUniqueId(), templateName);
            if (template == null) {
                throw new DominionException(Language.templateCommandText.templateNotExist, templateName);
            }
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            if (template.getFlagValue(Flags.ADMIN).booleanValue()) {
                Asserts.assertDominionOwner(player, dominion);
            } else {
                Asserts.assertDominionAdmin(player, dominion);
            }
            MemberDTO member = Converts.toMemberDTO(dominion, playerName);
            ((MemberDOO)member).applyTemplate(template);
            Notification.info(sender, Language.templateCommandText.applyTemplateSuccess, templateName, playerName);
        }
        catch (Exception e) {
            Notification.error(sender, Language.templateCommandText.applyTemplateFail, e.getMessage());
        }
    }

    public static void renameTemplate(CommandSender sender, String templateName, String newTemplateName, String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            TemplateDOO template = TemplateDOO.select(player.getUniqueId(), templateName);
            if (template == null) {
                throw new DominionException(Language.templateCommandText.templateNotExist, templateName);
            }
            if (newTemplateName.contains(" ")) {
                throw new DominionException(Language.templateCommandText.nameNotValid, new Object[0]);
            }
            template.setName(newTemplateName);
            Notification.info(sender, Language.templateCommandText.renameTemplateSuccess, newTemplateName);
            TemplateList.show(sender, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, Language.templateCommandText.renameTemplateFail, e.getMessage());
        }
    }

    public static class TemplateCommandText
    extends ConfigurationPart {
        public String nameNotValid = "Template name cannot contain space";
        public String templateNameExist = "Template {0} already exists";
        public String createTemplateFail = "Failed to create template, reason: {0}";
        public String createTemplateSuccess = "Successfully created template {0}";
        public String templateNotExist = "Template {0} does not exist";
        public String deleteTemplateSuccess = "Successfully deleted template {0}";
        public String deleteTemplateFail = "Failed to delete template, reason: {0}";
        public String applyTemplateSuccess = "Successfully applied template {0} to {1}";
        public String applyTemplateFail = "Failed to apply template, reason: {0}";
        public String setFlagSuccess = "Successfully set {0} flag of template {1} to {2}";
        public String setFlagFail = "Failed to set flag, reason: {0}";
        public String renameTemplateSuccess = "Successfully renamed template to {0}";
        public String renameTemplateFail = "Failed to rename template, reason: {0}";
        public String createTemplateDescription = "Create a new privilege template.";
        public String deleteTemplateDescription = "Delete an existing privilege template.";
        public String setTemplateFlagDescription = "Set a privilege flag in a template.";
        public String memberApplyTemplateDescription = "Apply a privilege template to a member.";
        public String renameTemplateDescription = "Rename an existing privilege template.";
    }
}

