/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.server.Cache;
import cn.lunadeer.dominion.cache.server.ServerCache;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.doos.PlayerDOO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class PlayerCache
extends Cache {
    private volatile ConcurrentHashMap<Integer, PlayerDTO> playerCache;
    private volatile ConcurrentHashMap<UUID, Integer> playerIdCache;
    private volatile ConcurrentHashMap<UUID, String> playerNameCache;
    private volatile ConcurrentHashMap<String, Integer> playerNameToId;
    private volatile ConcurrentHashMap<UUID, Integer> playerUsingTitleId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void loadExecution() throws Exception {
        ConcurrentHashMap<UUID, String> tempPlayerNameCache = new ConcurrentHashMap<UUID, String>();
        ConcurrentHashMap<String, Integer> tempPlayerNameToId = new ConcurrentHashMap<String, Integer>();
        ConcurrentHashMap<UUID, Integer> tempPlayerIdCache = new ConcurrentHashMap<UUID, Integer>();
        ConcurrentHashMap<UUID, Integer> tempPlayerUsingTitleId = new ConcurrentHashMap<UUID, Integer>();
        ConcurrentHashMap<Integer, PlayerDTO> tempPlayerCache = new ConcurrentHashMap<Integer, PlayerDTO>();
        List<PlayerDTO> players = PlayerDOO.all();
        for (PlayerDTO player : players) {
            tempPlayerIdCache.put(player.getUuid(), player.getId());
            tempPlayerNameToId.put(player.getLastKnownName(), player.getId());
            tempPlayerCache.put(player.getId(), player);
            tempPlayerNameCache.put(player.getUuid(), player.getLastKnownName());
            tempPlayerUsingTitleId.put(player.getUuid(), player.getUsingGroupTitleID());
        }
        PlayerCache playerCache = this;
        synchronized (playerCache) {
            this.playerNameCache = tempPlayerNameCache;
            this.playerNameToId = tempPlayerNameToId;
            this.playerIdCache = tempPlayerIdCache;
            this.playerUsingTitleId = tempPlayerUsingTitleId;
            this.playerCache = tempPlayerCache;
        }
    }

    @Override
    void loadExecution(Integer idToLoad) throws Exception {
        ConcurrentHashMap<Integer, PlayerDTO> currentPlayerCache = this.playerCache;
        if (currentPlayerCache == null) {
            return;
        }
        PlayerDTO player = currentPlayerCache.remove(idToLoad);
        if (player != null) {
            ConcurrentHashMap<UUID, Integer> currentPlayerIdCache = this.playerIdCache;
            ConcurrentHashMap<UUID, String> currentPlayerNameCache = this.playerNameCache;
            ConcurrentHashMap<UUID, Integer> currentPlayerUsingTitleId = this.playerUsingTitleId;
            ConcurrentHashMap<String, Integer> currentPlayerNameToId = this.playerNameToId;
            if (currentPlayerIdCache != null) {
                currentPlayerIdCache.remove(player.getUuid());
            }
            if (currentPlayerNameCache != null) {
                currentPlayerNameCache.remove(player.getUuid());
            }
            if (currentPlayerUsingTitleId != null) {
                currentPlayerUsingTitleId.remove(player.getUuid());
            }
            if (currentPlayerNameToId != null) {
                currentPlayerNameToId.remove(player.getLastKnownName());
            }
        }
        if ((player = PlayerDOO.selectById(idToLoad)) == null) {
            return;
        }
        ConcurrentHashMap<Integer, PlayerDTO> currentPlayerCacheForUpdate = this.playerCache;
        ConcurrentHashMap<UUID, Integer> currentPlayerIdCacheForUpdate = this.playerIdCache;
        ConcurrentHashMap<UUID, String> currentPlayerNameCacheForUpdate = this.playerNameCache;
        ConcurrentHashMap<UUID, Integer> currentPlayerUsingTitleIdForUpdate = this.playerUsingTitleId;
        ConcurrentHashMap<String, Integer> currentPlayerNameToIdForUpdate = this.playerNameToId;
        if (currentPlayerCacheForUpdate != null) {
            currentPlayerCacheForUpdate.put(player.getId(), player);
        }
        if (currentPlayerIdCacheForUpdate != null) {
            currentPlayerIdCacheForUpdate.put(player.getUuid(), player.getId());
        }
        if (currentPlayerNameCacheForUpdate != null) {
            currentPlayerNameCacheForUpdate.put(player.getUuid(), player.getLastKnownName());
        }
        if (currentPlayerUsingTitleIdForUpdate != null) {
            currentPlayerUsingTitleIdForUpdate.put(player.getUuid(), player.getUsingGroupTitleID());
        }
        if (currentPlayerNameToIdForUpdate != null) {
            currentPlayerNameToIdForUpdate.put(player.getLastKnownName(), player.getId());
        }
    }

    @Override
    void deleteExecution(Integer idToDelete) throws Exception {
        ConcurrentHashMap<Integer, PlayerDTO> currentPlayerCache = this.playerCache;
        if (currentPlayerCache == null) {
            return;
        }
        PlayerDTO player = currentPlayerCache.remove(idToDelete);
        if (player != null) {
            ConcurrentHashMap<UUID, Integer> currentPlayerIdCache = this.playerIdCache;
            ConcurrentHashMap<UUID, String> currentPlayerNameCache = this.playerNameCache;
            ConcurrentHashMap<UUID, Integer> currentPlayerUsingTitleId = this.playerUsingTitleId;
            ConcurrentHashMap<String, Integer> currentPlayerNameToId = this.playerNameToId;
            if (currentPlayerIdCache != null) {
                currentPlayerIdCache.remove(player.getUuid());
            }
            if (currentPlayerNameCache != null) {
                currentPlayerNameCache.remove(player.getUuid());
            }
            if (currentPlayerUsingTitleId != null) {
                currentPlayerUsingTitleId.remove(player.getUuid());
            }
            if (currentPlayerNameToId != null) {
                currentPlayerNameToId.remove(player.getLastKnownName());
            }
        }
    }

    @Nullable
    public PlayerDTO getPlayer(UUID uuid) {
        ConcurrentHashMap<UUID, Integer> currentPlayerIdCache = this.playerIdCache;
        ConcurrentHashMap<Integer, PlayerDTO> currentPlayerCache = this.playerCache;
        if (currentPlayerIdCache != null && currentPlayerCache != null && currentPlayerIdCache.containsKey(uuid)) {
            return currentPlayerCache.get(currentPlayerIdCache.get(uuid));
        }
        return null;
    }

    @Nullable
    public PlayerDTO getPlayer(String name) {
        ConcurrentHashMap<String, Integer> currentPlayerNameToId = this.playerNameToId;
        ConcurrentHashMap<Integer, PlayerDTO> currentPlayerCache = this.playerCache;
        if (currentPlayerNameToId != null && currentPlayerCache != null && currentPlayerNameToId.containsKey(name)) {
            return currentPlayerCache.get(currentPlayerNameToId.get(name));
        }
        return null;
    }

    public String getPlayerName(UUID uuid) {
        ConcurrentHashMap<UUID, String> currentPlayerNameCache = this.playerNameCache;
        if (currentPlayerNameCache != null && currentPlayerNameCache.containsKey(uuid)) {
            return currentPlayerNameCache.get(uuid);
        }
        return "Unknown Player: %s".formatted(uuid);
    }

    public List<String> getPlayerNames() {
        ConcurrentHashMap<UUID, String> currentPlayerNameCache = this.playerNameCache;
        return currentPlayerNameCache != null ? new ArrayList<String>(currentPlayerNameCache.values()) : new ArrayList();
    }

    public Integer getPlayerUsingTitleId(UUID uuid) {
        ConcurrentHashMap<UUID, Integer> currentPlayerUsingTitleId = this.playerUsingTitleId;
        return currentPlayerUsingTitleId != null ? currentPlayerUsingTitleId.getOrDefault(uuid, -1) : -1;
    }

    public List<GroupDTO> getPlayerGroupTitleList(UUID uuid) {
        ArrayList<GroupDTO> groupTitleList = new ArrayList<GroupDTO>();
        List<MemberDTO> playerBelongedDominionMembers = Objects.requireNonNull(CacheManager.instance.getCache()).getMemberCache().getMemberBelongedDominions(uuid);
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : CacheManager.instance.getOtherServerCaches().values()) {
                playerBelongedDominionMembers.addAll(serverCache.getMemberCache().getMemberBelongedDominions(uuid));
            }
        }
        for (MemberDTO member : playerBelongedDominionMembers) {
            GroupDTO group;
            if (member.getGroupId() == -1 || (group = CacheManager.instance.getGroup(member.getGroupId())) == null) continue;
            groupTitleList.add(group);
        }
        return groupTitleList;
    }
}

