/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Cache {
    private final AtomicLong lastTask = new AtomicLong(0L);
    private final AtomicBoolean taskScheduled = new AtomicBoolean(false);

    public void load() {
        if (this.getLastTaskTimeStamp() + CacheManager.UPDATE_INTERVAL < System.currentTimeMillis()) {
            XLogger.debug("run loadExecution immediately");
            this.resetLastTaskTimeStamp();
            try {
                this.loadExecution();
            }
            catch (Exception e) {
                XLogger.error(e);
            }
        } else {
            this.scheduleLoad();
        }
    }

    public void delete(Integer idToDelete) {
        if (this.getLastTaskTimeStamp() + CacheManager.UPDATE_INTERVAL < System.currentTimeMillis()) {
            XLogger.debug("run loadExecution immediately");
            this.resetLastTaskTimeStamp();
            try {
                this.deleteExecution(idToDelete);
            }
            catch (Exception e) {
                XLogger.error(e);
            }
        } else {
            this.scheduleLoad();
        }
    }

    private void scheduleLoad() {
        if (this.isTaskScheduled().booleanValue()) {
            return;
        }
        XLogger.debug("schedule loadExecution");
        this.setTaskScheduled();
        Scheduler.runTaskLaterAsync(() -> {
            XLogger.debug("scheduled loadExecution run");
            try {
                this.resetLastTaskTimeStamp();
                this.loadExecution();
            }
            catch (Exception e) {
                XLogger.error(e);
            }
            finally {
                this.unsetTaskScheduled();
            }
        }, this.getTaskScheduledDelayTick());
    }

    public void load(Integer idToLoad) {
        if (this.getLastTaskTimeStamp() + CacheManager.UPDATE_INTERVAL < System.currentTimeMillis()) {
            this.resetLastTaskTimeStamp();
            try {
                this.loadExecution(idToLoad);
            }
            catch (Exception e) {
                XLogger.error(e);
            }
        } else {
            if (this.isTaskScheduled().booleanValue()) {
                return;
            }
            this.setTaskScheduled();
            Scheduler.runTaskLaterAsync(() -> {
                try {
                    this.resetLastTaskTimeStamp();
                    this.loadExecution();
                }
                catch (Exception e) {
                    XLogger.error(e);
                }
                finally {
                    this.unsetTaskScheduled();
                }
            }, this.getTaskScheduledDelayTick());
        }
    }

    abstract void loadExecution() throws Exception;

    abstract void loadExecution(Integer var1) throws Exception;

    abstract void deleteExecution(Integer var1) throws Exception;

    private Long getLastTaskTimeStamp() {
        return this.lastTask.get();
    }

    private void resetLastTaskTimeStamp() {
        this.lastTask.set(System.currentTimeMillis());
    }

    private Boolean isTaskScheduled() {
        return this.taskScheduled.get();
    }

    private void setTaskScheduled() {
        this.taskScheduled.set(true);
    }

    private void unsetTaskScheduled() {
        this.taskScheduled.set(false);
    }

    private long getTaskScheduledDelayTick() {
        return (CacheManager.UPDATE_INTERVAL - (System.currentTimeMillis() - this.getLastTaskTimeStamp())) / 1000L * 20L;
    }
}

