/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.scui.configuration;

import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.configuration.HandleManually;
import java.net.URL;
import java.util.List;
import org.bukkit.Material;

public class ButtonConfiguration
extends ConfigurationPart {
    public String symbol;
    public String name;
    public List<String> lore;
    public String material;

    @HandleManually
    public static ButtonConfiguration createMaterial(char symbol, Material material, String name, List<String> lore) {
        ButtonConfiguration buttonConfig = new ButtonConfiguration();
        buttonConfig.symbol = String.valueOf(symbol);
        buttonConfig.name = name;
        buttonConfig.lore = lore;
        buttonConfig.material = material.name();
        return buttonConfig;
    }

    @HandleManually
    public static ButtonConfiguration createHeadByB64(char symbol, String textureB64, String name, List<String> lore) {
        ButtonConfiguration buttonConfig = new ButtonConfiguration();
        buttonConfig.symbol = String.valueOf(symbol);
        buttonConfig.name = name;
        buttonConfig.lore = lore;
        buttonConfig.material = "PLAYER_HEAD;B64;" + textureB64;
        return buttonConfig;
    }

    @HandleManually
    public static ButtonConfiguration createHeadByName(char symbol, String playerName, String name, List<String> lore) {
        ButtonConfiguration buttonConfig = new ButtonConfiguration();
        buttonConfig.symbol = String.valueOf(symbol);
        buttonConfig.name = name;
        buttonConfig.lore = lore;
        buttonConfig.material = "PLAYER_HEAD;NAME;" + playerName;
        return buttonConfig;
    }

    @HandleManually
    public static ButtonConfiguration createHeadByUrl(char symbol, URL skinUrl, String name, List<String> lore) {
        ButtonConfiguration buttonConfig = new ButtonConfiguration();
        buttonConfig.symbol = String.valueOf(symbol);
        buttonConfig.name = name;
        buttonConfig.lore = lore;
        buttonConfig.material = "PLAYER_HEAD;URL;" + skinUrl.toString();
        return buttonConfig;
    }

    @HandleManually
    public char getSymbol() {
        return this.symbol.charAt(0);
    }
}

