/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.member;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.commands.TemplateCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.doos.TemplateDOO;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.dominion.manage.member.MemberFlags;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class SelectTemplate
extends AbstractUI {
    public static void show(CommandSender sender, String dominionName, String playerName, String pageStr) {
        new SelectTemplate().displayByPreference(sender, dominionName, playerName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName, final String playerName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.selectTemplateTuiText.button){

            @Override
            public void function(String pageStr) {
                SelectTemplate.show(sender, dominionName, playerName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission).setHoverText(TextUserInterface.selectTemplateTuiText.description);
    }

    @Override
    protected void showTUI(final Player player, String ... args) throws Exception {
        final String dominionName = args[0];
        final String playerName = args[1];
        String pageStr = args[2];
        int page = Converts.toIntegrity(pageStr);
        List<TemplateDOO> templates = TemplateDOO.selectAll(player.getUniqueId());
        ListView view = ListView.create(10, SelectTemplate.button((CommandSender)player, dominionName, playerName));
        view.title(TextUserInterface.selectTemplateTuiText.title);
        Line sub = Line.create().append(MemberFlags.button((CommandSender)player, dominionName, playerName).setText(TextUserInterface.selectTemplateTuiText.back).build());
        view.subtitle(sub);
        for (final TemplateDOO template : templates) {
            view.add(Line.create().append(new FunctionalButton(TextUserInterface.selectTemplateTuiText.apply){

                @Override
                public void function() {
                    TemplateCommand.memberApplyTemplate((CommandSender)player, dominionName, playerName, template.getName());
                }
            }.build()).append(Component.text((String)template.getName())));
        }
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final String dominionName = args[0];
        final String playerName = args[1];
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.selectTemplateCui.title, playerName));
        view.applyListConfiguration(ChestUserInterface.selectTemplateCui.listConfiguration, Converts.toIntegrity(args[2]));
        view.setButton(ChestUserInterface.selectTemplateCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.selectTemplateCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MemberFlags.show((CommandSender)player, dominionName, playerName, "1");
            }
        });
        List<TemplateDOO> templates = TemplateDOO.selectAll(player.getUniqueId());
        for (final TemplateDOO template : templates) {
            ChestButton templateChest = new ChestButton(ChestUserInterface.selectTemplateCui.templateButton){

                @Override
                public void onClick(ClickType type) {
                    TemplateCommand.memberApplyTemplate((CommandSender)player, dominionName, playerName, template.getName());
                    MemberFlags.show((CommandSender)player, dominionName, playerName, "1");
                }
            }.setDisplayNameArgs(template.getName()).setLoreArgs(playerName, template.getName());
            view.addItem(templateChest);
        }
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
    }

    public static class SelectTemplateTuiText
    extends ConfigurationPart {
        public String title = "Select Template";
        public String description = "Select a template to apply to this member.";
        public String button = "SELECT TEMPLATE";
        public String back = "BACK";
        public String apply = "APPLY";
    }

    public static class SelectTemplateCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a75\u00a7lSelect Template for {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.BARRIER, "\u00a7c\u00ab Back to Member Settings", List.of("\u00a77Return to the member settings", "\u00a77without applying a template.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration templateButton = ButtonConfiguration.createMaterial('i', Material.WRITABLE_BOOK, "\u00a7a\u2699 \u00a72{0}", List.of("\u00a77Apply this permission template", "\u00a77to member {0}.", "", "\u00a77Template: \u00a7e{1}", "", "\u00a72\u25b6 Click to apply template", "", "\u00a78This will override member's", "\u00a78current permissions."));
    }
}

