/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.AdministratorCommand;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.inputters.CreateDominionInputter;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.AllDominion;
import cn.lunadeer.dominion.uis.MigrateList;
import cn.lunadeer.dominion.uis.TitleList;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.template.TemplateList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.CommandManager;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.ChestView;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.ViewStyles;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.PermissionButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.UrlButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class MainMenu
extends AbstractUI {
    public static SecondaryCommand menu = new SecondaryCommand("menu", List.of(new CommandArguments.OptionalPageArgument()), Language.uiCommandsDescription.mainMenu){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                MainMenu.show(sender, this.getArgumentValue(0));
            }
            catch (Exception e) {
                Notification.error(sender, e);
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String pageStr) {
        new MainMenu().displayByPreference(sender, pageStr);
    }

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(TextUserInterface.menuTuiText.button){

            @Override
            public void function(String pageStr) {
                MainMenu.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final Player player, String ... args) {
        int page = Converts.toIntegrity(args[0], 1);
        Line create = Line.create().append(CreateDominionInputter.createTuiButtonOn((CommandSender)player).needPermission(Dominion.defaultPermission).build()).append(Language.createDominionInputterText.description);
        Line list = Line.create().append(DominionList.button((CommandSender)player).build()).append(TextUserInterface.dominionListTuiText.description);
        Line title = Line.create().append(TitleList.button((CommandSender)player).build()).append(TextUserInterface.titleListTuiText.description);
        Line template = Line.create().append(TemplateList.button((CommandSender)player).build()).append(TextUserInterface.templateListTuiText.description);
        Line help = Line.create().append(new UrlButton(TextUserInterface.menuTuiText.commandHelpButton, Configuration.externalLinks.commandHelp).build()).append(TextUserInterface.menuTuiText.commandHelpDescription);
        Line link = Line.create().append(new UrlButton(TextUserInterface.menuTuiText.documentButton, Configuration.externalLinks.documentation).build()).append(TextUserInterface.menuTuiText.documentDescription);
        Line migrate = Line.create().append(MigrateList.button((CommandSender)player).build()).append(TextUserInterface.migrateListTuiText.description);
        Line all = Line.create().append(AllDominion.button((CommandSender)player).build()).append(TextUserInterface.allDominionTuiText.description);
        Line reload_cache = Line.create().append(AdministratorCommand.reloadCacheButton((CommandSender)player).build()).append(Language.administratorCommandText.reloadCacheDescription);
        Line reload_config = Line.create().append(AdministratorCommand.reloadConfigButton((CommandSender)player).build()).append(Language.administratorCommandText.reloadConfigDescription);
        PermissionButton switchToCui = new FunctionalButton(TextUserInterface.menuTuiText.switchToCuiButton){

            @Override
            public void function() {
                try {
                    PlayerDTO p = CacheManager.instance.getPlayer(player.getUniqueId());
                    if (p == null) {
                        throw new IllegalStateException("Player data not found in cache.");
                    }
                    p.setUiPreference(PlayerDTO.UI_TYPE.CUI);
                    MainMenu.show((CommandSender)player, "1");
                }
                catch (Exception e) {
                    Notification.error((CommandSender)player, TextUserInterface.menuTuiText.failToSwitchMessage, "CUI", e.getMessage());
                }
            }
        }.needPermission(Dominion.defaultPermission);
        ListView view = ListView.create(10, MainMenu.button((CommandSender)player));
        view.title(TextUserInterface.menuTuiText.title);
        view.navigator(Line.create().append(TextUserInterface.menuTuiText.button).append(switchToCui.build()));
        view.add(create);
        view.add(list);
        if (Configuration.groupTitle.enable) {
            view.add(title);
        }
        view.add(template);
        if (!Configuration.externalLinks.commandHelp.isEmpty()) {
            view.add(help);
        }
        if (!Configuration.externalLinks.documentation.isEmpty()) {
            view.add(link);
        }
        if (Configuration.residenceMigration) {
            view.add(migrate);
        }
        if (player.hasPermission(Dominion.adminPermission)) {
            view.add(Line.create().append(""));
            view.add(Line.create().append(Component.text((String)TextUserInterface.menuTuiText.adminOnlySection, (TextColor)ViewStyles.PRIMARY)));
            view.add(all);
            view.add(reload_cache);
            view.add(reload_config);
        }
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) {
        final ChestView view = ChestUserInterfaceManager.getInstance().getViewOf(player).setTitle(ChestUserInterface.mainMenuCui.title);
        if (player.hasPermission(Dominion.adminPermission)) {
            view.setLayout(ChestUserInterface.mainMenuCui.adminLayout);
        } else {
            view.setLayout(ChestUserInterface.mainMenuCui.userLayout);
        }
        view.setButton(ChestUserInterface.mainMenuCui.createButton.getSymbol(), new ChestButton(ChestUserInterface.mainMenuCui.createButton){

            @Override
            public void onClick(ClickType type) {
                CreateDominionInputter.createOn((CommandSender)player);
                view.close();
            }
        });
        view.setButton(ChestUserInterface.mainMenuCui.listButton.getSymbol(), new ChestButton(ChestUserInterface.mainMenuCui.listButton){

            @Override
            public void onClick(ClickType type) {
                DominionList.show((CommandSender)player, "1");
            }
        });
        if (!Configuration.groupTitle.enable) {
            ChestUserInterface.mainMenuCui.titleButton.lore = ChestUserInterface.mainMenuCui.statusDisabledLore;
        }
        view.setButton(ChestUserInterface.mainMenuCui.titleButton.getSymbol(), new ChestButton(ChestUserInterface.mainMenuCui.titleButton){

            @Override
            public void onClick(ClickType type) {
                if (Configuration.groupTitle.enable) {
                    TitleList.show((CommandSender)player, "1");
                }
            }
        });
        view.setButton(ChestUserInterface.mainMenuCui.templateButton.getSymbol(), new ChestButton(ChestUserInterface.mainMenuCui.templateButton){

            @Override
            public void onClick(ClickType type) {
                TemplateList.show((CommandSender)player, "1");
            }
        });
        if (!Configuration.residenceMigration) {
            ChestUserInterface.mainMenuCui.migrateButton.lore = ChestUserInterface.mainMenuCui.statusDisabledLore;
        }
        view.setButton(ChestUserInterface.mainMenuCui.migrateButton.getSymbol(), new ChestButton(ChestUserInterface.mainMenuCui.migrateButton){

            @Override
            public void onClick(ClickType type) {
                if (Configuration.residenceMigration) {
                    MigrateList.show((CommandSender)player, "1");
                }
            }
        });
        if (player.hasPermission(Dominion.adminPermission)) {
            view.setButton(ChestUserInterface.mainMenuCui.allButton.getSymbol(), new ChestButton(ChestUserInterface.mainMenuCui.allButton){

                @Override
                public void onClick(ClickType type) {
                    AllDominion.show((CommandSender)player, "1");
                }
            });
        }
        view.setButton(ChestUserInterface.mainMenuCui.switchTuiButton.getSymbol(), new ChestButton(ChestUserInterface.mainMenuCui.switchTuiButton){

            @Override
            public void onClick(ClickType type) {
                try {
                    PlayerDTO p = CacheManager.instance.getPlayer(player.getUniqueId());
                    if (p == null) {
                        throw new IllegalStateException("Player data not found in cache.");
                    }
                    p.setUiPreference(PlayerDTO.UI_TYPE.TUI);
                    view.close();
                    MainMenu.show((CommandSender)player, "1");
                }
                catch (Exception e) {
                    Notification.error((CommandSender)player, TextUserInterface.menuTuiText.failToSwitchMessage, "TUI", e.getMessage());
                }
            }
        });
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
        Notification.info(sender, ChestUserInterface.mainMenuCui.title);
        Notification.info(sender, AllDominion.listAll.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, AllDominion.listAll.getDescription());
        Notification.info(sender, MigrateList.migrateList.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, MigrateList.migrateList.getDescription());
        Notification.info(sender, AdministratorCommand.reloadCache.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, AdministratorCommand.reloadCache.getDescription());
        Notification.info(sender, AdministratorCommand.updateLanguage.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, AdministratorCommand.updateLanguage.getDescription());
        Notification.info(sender, CommandManager.getInstance().helpCommand.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, CommandManager.getInstance().helpCommand.getDescription());
    }

    public static class MenuTuiText
    extends ConfigurationPart {
        public String title = "Dominion Menu";
        public String button = "MENU";
        public String adminOnlySection = "Only admin can see this section";
        public String documentButton = "DOCUMENT";
        public String documentDescription = "Open the documentation external link.";
        public String commandHelpButton = "COMMAND HELP";
        public String commandHelpDescription = "Open the command help external link.";
        public String switchToCuiButton = " SWITCH TO CUI \ud83c\udd95 ";
        public String failToSwitchMessage = "Failed to switch to {0}: {1}";
    }

    public static class MainMenuCui
    extends ConfigurationPart {
        public String title = "\u00a7b\u2726 \u00a76\u00a7lDominion Main Menu \u00a7b\u2726";
        public List<String> adminLayout = List.of("#########", "##A#B#C##", "##D#E#F##", "#########", "####S####");
        public List<String> userLayout = List.of("#########", "##A#B#C##", "###D#E###", "#########", "####S####");
        public List<String> statusDisabledLore = List.of("\u00a7c\u2718 \u00a74This feature is currently disabled.", "\u00a77Please check back later or contact", "\u00a77\u00a7oServer Administrators \u00a7rfor more info.", "", "\u00a78\u00a7lStatus: \u00a7c\u2718 Disabled by Operator");
        public ButtonConfiguration createButton = ButtonConfiguration.createMaterial('A', Material.NETHER_STAR, "\u00a76\u2728 \u00a7eCreate Dominion \u00a76\u2728", List.of("\u00a77Start your empire by creating", "\u00a77a new dominion at your location.", "", "\u00a7e\u25b6 Click to begin creation", "", "\u00a78Tip: Make sure you're in the", "\u00a78area you want to claim!"));
        public ButtonConfiguration listButton = ButtonConfiguration.createMaterial('B', Material.BOOKSHELF, "\u00a7b\ud83d\udccb \u00a7fManage My Dominions", List.of("\u00a77View and manage all dominions", "\u00a77that you have access to.", "", "\u00a7b\u25b6 Click to view list", "", "\u00a78Includes: Your dominions &", "\u00a78dominions you're admin of!"));
        public ButtonConfiguration titleButton = ButtonConfiguration.createMaterial('C', Material.NAME_TAG, "\u00a76\ud83d\udc51 \u00a7eGroup Titles", List.of("\u00a77Browse and equip titles from", "\u00a77groups you're member of.", "", "\u00a7e\u25b6 Click to browse titles", "", "\u00a78Show off your rank and", "\u00a78membership status!"));
        public ButtonConfiguration templateButton = ButtonConfiguration.createMaterial('D', Material.WRITABLE_BOOK, "\u00a7a\ud83d\udcdd \u00a7fTemplate Manager", List.of("\u00a77Create and manage permission", "\u00a77templates for quick setup.", "", "\u00a7a\u25b6 Click to manage templates", "", "\u00a78Save time when setting up", "\u00a78new dominions!"));
        public ButtonConfiguration migrateButton = ButtonConfiguration.createMaterial('E', Material.ENDER_PEARL, "\u00a7d\ud83d\udd04 \u00a7fMigrate from Residence", List.of("\u00a77Convert your existing Residence", "\u00a77plots to Dominion format.", "", "\u00a7d\u25b6 Click to start migration", "", "\u00a7c\u26a0 Make sure to backup first!", "\u00a78This process is irreversible."));
        public ButtonConfiguration allButton = ButtonConfiguration.createMaterial('F', Material.DIAMOND, "\u00a7c\ud83d\udc8e \u00a7fAll Server Dominions", List.of("\u00a77\u00a7lADMIN ONLY\u00a7r", "\u00a77View all dominions across", "\u00a77the entire server.", "", "\u00a7c\u25b6 Click to view all dominions", "", "\u00a78Perfect for server management", "\u00a78and moderation purposes."));
        public ButtonConfiguration switchTuiButton = ButtonConfiguration.createMaterial('S', Material.COMPASS, "\u00a7e\u00a7lSwitch to TUI", List.of("\u00a77Switch to the text-based TUI", "\u00a77for a different user interface.", "", "\u00a7e\u25b6 Click to switch to TUI", "", "\u00a78Use this if you prefer a", "\u00a78text-based experience!"));
    }
}

