/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.utils.ResMigration;
import cn.lunadeer.dominion.utils.XLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class ResidenceDataCache {
    private Map<UUID, CopyOnWriteArrayList<ResMigration.ResidenceNode>> residence_data = null;

    private void updateResidenceData() {
        if (this.residence_data == null) {
            this.residence_data = new HashMap<UUID, CopyOnWriteArrayList<ResMigration.ResidenceNode>>();
            List<ResMigration.ResidenceNode> residences = ResMigration.extractFromResidence(Dominion.instance);
            for (ResMigration.ResidenceNode node : residences) {
                if (node == null) continue;
                if (!this.residence_data.containsKey(node.owner)) {
                    XLogger.debug("residence_data put {0}", node.owner);
                    this.residence_data.put(node.owner, new CopyOnWriteArrayList());
                }
                this.residence_data.get(node.owner).add(node);
            }
            XLogger.debug("residence_data: {0}", this.residence_data.size());
        }
    }

    public List<ResMigration.ResidenceNode> getResidenceData() {
        this.updateResidenceData();
        return this.residence_data.values().stream().reduce(new CopyOnWriteArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    public List<ResMigration.ResidenceNode> getResidenceData(UUID player_uuid) {
        this.updateResidenceData();
        return this.residence_data.get(player_uuid);
    }
}

