/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.holograme;

import cn.lunadeer.dominion.utils.holograme.HoloElement;
import cn.lunadeer.dominion.utils.holograme.HoloManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class HoloItem {
    private final String name;
    private Location anchor;
    private Quaternionf rotation = new Quaternionf();
    private final Map<String, HoloElement> elements = new LinkedHashMap<String, HoloElement>();
    private final Set<Player> viewers = new HashSet<Player>();

    HoloItem(String name, Location anchor) {
        this.name = name;
        this.anchor = anchor.clone();
    }

    public HoloElement addBlockDisplay(String elementName, Material material) {
        return this.addBlockDisplay(elementName, material.createBlockData());
    }

    public HoloElement addBlockDisplay(String elementName, BlockData blockData) {
        if (this.elements.containsKey(elementName)) {
            throw new IllegalArgumentException("Element '" + elementName + "' already exists in HoloItem '" + this.name + "'");
        }
        World world = this.anchor.getWorld();
        if (world == null) {
            throw new IllegalStateException("Anchor location has no world");
        }
        HoloElement element = new HoloElement(elementName, this, this.anchor.clone(), blockData);
        this.elements.put(elementName, element);
        element.updateTransform();
        if (!this.viewers.isEmpty()) {
            element.spawnFor(this.getOnlineViewers());
        }
        return element;
    }

    public HoloElement addItemDisplay(String elementName, Material material) {
        return this.addItemDisplay(elementName, new ItemStack(material));
    }

    public HoloElement addItemDisplay(String elementName, ItemStack itemStack) {
        if (this.elements.containsKey(elementName)) {
            throw new IllegalArgumentException("Element '" + elementName + "' already exists in HoloItem '" + this.name + "'");
        }
        World world = this.anchor.getWorld();
        if (world == null) {
            throw new IllegalStateException("Anchor location has no world");
        }
        HoloElement element = new HoloElement(elementName, this, this.anchor.clone(), itemStack);
        this.elements.put(elementName, element);
        element.updateTransform();
        if (!this.viewers.isEmpty()) {
            element.spawnFor(this.getOnlineViewers());
        }
        return element;
    }

    public HoloItem removeElement(String elementName) {
        HoloElement element = this.elements.remove(elementName);
        if (element != null) {
            if (!this.viewers.isEmpty()) {
                element.destroyFor(this.getOnlineViewers());
            }
            element.remove();
        }
        return this;
    }

    public HoloElement getElement(String elementName) {
        return this.elements.get(elementName);
    }

    public boolean hasElement(String elementName) {
        return this.elements.containsKey(elementName);
    }

    public Set<String> getElementNames() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public Collection<HoloElement> getElements() {
        return Collections.unmodifiableCollection(this.elements.values());
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public HoloItem setPosition(Location location) {
        this.anchor = location.clone();
        this.updateAll();
        return this;
    }

    public HoloItem move(double dx, double dy, double dz) {
        this.anchor.add(dx, dy, dz);
        this.updateAll();
        return this;
    }

    public HoloItem setRotation(float yaw, float pitch) {
        return this.setRotation(yaw, pitch, 0.0f);
    }

    public HoloItem setRotation(float yaw, float pitch, float roll) {
        this.rotation = new Quaternionf().rotateY((float)Math.toRadians(-yaw)).rotateX((float)Math.toRadians(pitch)).rotateZ((float)Math.toRadians(roll));
        this.updateAll();
        return this;
    }

    public HoloItem setRotation(Quaternionf rotation) {
        this.rotation = new Quaternionf((Quaternionfc)rotation);
        this.updateAll();
        return this;
    }

    public HoloItem show(Player player) {
        if (player == null || !player.isOnline()) {
            return this;
        }
        if (this.viewers.contains(player)) {
            return this;
        }
        this.viewers.add(player);
        for (HoloElement element : this.elements.values()) {
            element.spawnFor(player);
        }
        return this;
    }

    public HoloItem show(Collection<? extends Player> players) {
        for (Player player : players) {
            this.show(player);
        }
        return this;
    }

    public HoloItem hide(Player player) {
        if (player == null) {
            return this;
        }
        if (!this.viewers.remove(player)) {
            return this;
        }
        if (player.isOnline()) {
            for (HoloElement element : this.elements.values()) {
                element.destroyFor(player);
            }
        }
        return this;
    }

    public HoloItem hide(Collection<? extends Player> players) {
        for (Player player : players) {
            this.hide(player);
        }
        return this;
    }

    public HoloItem hideAll() {
        ArrayList<Player> currentViewers = new ArrayList<Player>(this.viewers);
        for (Player player : currentViewers) {
            this.hide(player);
        }
        return this;
    }

    public boolean isViewedBy(Player player) {
        return this.viewers.contains(player);
    }

    public Set<Player> getViewers() {
        return Collections.unmodifiableSet(this.viewers);
    }

    private List<Player> getOnlineViewers() {
        ArrayList<Player> online = new ArrayList<Player>();
        Iterator<Player> it = this.viewers.iterator();
        while (it.hasNext()) {
            Player p = it.next();
            if (p.isOnline()) {
                online.add(p);
                continue;
            }
            it.remove();
        }
        return online;
    }

    public String getName() {
        return this.name;
    }

    public Location getAnchor() {
        return this.anchor.clone();
    }

    public Quaternionf getRotation() {
        return new Quaternionf((Quaternionfc)this.rotation);
    }

    public void updateAll() {
        List<Player> online = this.getOnlineViewers();
        for (HoloElement element : this.elements.values()) {
            element.updateTransform();
            if (online.isEmpty()) continue;
            element.sendTo(online);
        }
    }

    public void remove() {
        List<Player> online = this.getOnlineViewers();
        for (HoloElement element : this.elements.values()) {
            if (!online.isEmpty()) {
                element.destroyFor(online);
            }
            element.remove();
        }
        this.elements.clear();
        this.viewers.clear();
        HoloManager.instance().untrack(this.name);
    }

    public String toString() {
        return String.format("HoloItem{name='%s', anchor=%s, elements=%d, viewers=%d}", this.name, this.anchor.getWorld() != null ? String.format("(%s, %.1f, %.1f, %.1f)", this.anchor.getWorld().getName(), this.anchor.getX(), this.anchor.getY(), this.anchor.getZ()) : "null", this.elements.size(), this.viewers.size());
    }
}

