/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.holograme;

import cn.lunadeer.dominion.nms.FakeEntity;
import cn.lunadeer.dominion.nms.NMSManager;
import cn.lunadeer.dominion.utils.holograme.HoloItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HoloElement {
    private final String name;
    private final Type type;
    private FakeEntity fakeEntity;
    private HoloItem parent;
    private final Vector3f relativeOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Vector3f localScale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Quaternionf localRotation = new Quaternionf();
    private final Vector3f translationOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    private BlockData blockData;
    private ItemStack itemStack;

    HoloElement(String name, HoloItem parent, Location spawnLocation, BlockData blockData) {
        this.name = name;
        this.type = Type.BLOCK_DISPLAY;
        this.parent = parent;
        this.blockData = blockData;
        this.fakeEntity = NMSManager.instance().getFakeEntityFactory().createBlockDisplay(spawnLocation, blockData);
    }

    HoloElement(String name, HoloItem parent, Location spawnLocation, ItemStack itemStack) {
        this.name = name;
        this.type = Type.ITEM_DISPLAY;
        this.parent = parent;
        this.itemStack = itemStack;
        this.fakeEntity = NMSManager.instance().getFakeEntityFactory().createItemDisplay(spawnLocation, itemStack);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public FakeEntity getFakeEntity() {
        return this.fakeEntity;
    }

    public Vector3f getRelativeOffset() {
        return new Vector3f((Vector3fc)this.relativeOffset);
    }

    public Vector3f getLocalScale() {
        return new Vector3f((Vector3fc)this.localScale);
    }

    public Quaternionf getLocalRotation() {
        return new Quaternionf((Quaternionfc)this.localRotation);
    }

    public Vector3f getTranslationOffset() {
        return new Vector3f((Vector3fc)this.translationOffset);
    }

    public BlockData getBlockData() {
        return this.blockData;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public HoloElement offset(float x, float y, float z) {
        this.relativeOffset.set(x, y, z);
        this.updateTransform();
        return this;
    }

    public HoloElement scale(float x, float y, float z) {
        this.localScale.set(x, y, z);
        this.updateTransform();
        return this;
    }

    public HoloElement scale(float uniform) {
        return this.scale(uniform, uniform, uniform);
    }

    public HoloElement rotate(float yaw, float pitch, float roll) {
        this.localRotation = new Quaternionf().rotateY((float)Math.toRadians(-yaw)).rotateX((float)Math.toRadians(pitch)).rotateZ((float)Math.toRadians(roll));
        this.updateTransform();
        return this;
    }

    public HoloElement rotate(Quaternionf rotation) {
        this.localRotation = new Quaternionf((Quaternionfc)rotation);
        this.updateTransform();
        return this;
    }

    public HoloElement translation(float x, float y, float z) {
        this.translationOffset.set(x, y, z);
        this.updateTransform();
        return this;
    }

    public HoloElement glow(boolean glowing) {
        return this;
    }

    public HoloElement glowColor(Color color) {
        if (this.fakeEntity != null) {
            this.fakeEntity.setGlowColor(color);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement brightness(int blockLight, int skyLight) {
        if (this.fakeEntity != null) {
            this.fakeEntity.setBrightness(blockLight, skyLight);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement billboard(byte billboard) {
        if (this.fakeEntity != null) {
            this.fakeEntity.setBillboard(billboard);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement viewRange(float range) {
        if (this.fakeEntity != null) {
            this.fakeEntity.setViewRange(range);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement shadow(float radius, float strength) {
        if (this.fakeEntity != null) {
            this.fakeEntity.setShadow(radius, strength);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement interpolationDuration(int ticks) {
        if (this.fakeEntity != null) {
            this.fakeEntity.setInterpolationDuration(ticks);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement interpolationDelay(int ticks) {
        if (this.fakeEntity != null) {
            this.fakeEntity.setInterpolationDelay(ticks);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement setBlockData(BlockData data) {
        if (this.type == Type.BLOCK_DISPLAY && this.fakeEntity != null) {
            this.blockData = data;
            this.fakeEntity.setBlockData(data);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement setItemStack(ItemStack stack) {
        if (this.type == Type.ITEM_DISPLAY && this.fakeEntity != null) {
            this.itemStack = stack;
            this.fakeEntity.setItemStack(stack);
            this.syncToViewers();
        }
        return this;
    }

    public HoloElement itemTransform(byte transform) {
        if (this.type == Type.ITEM_DISPLAY && this.fakeEntity != null) {
            this.fakeEntity.setItemTransform(transform);
            this.syncToViewers();
        }
        return this;
    }

    private void syncToViewers() {
        if (this.fakeEntity == null || this.parent == null) {
            return;
        }
        Set<Player> viewers = this.parent.getViewers();
        if (!viewers.isEmpty()) {
            ArrayList<Player> onlineViewers = new ArrayList<Player>();
            for (Player viewer : viewers) {
                if (!viewer.isOnline()) continue;
                onlineViewers.add(viewer);
            }
            if (!onlineViewers.isEmpty()) {
                this.fakeEntity.sendMetadata(onlineViewers);
            }
        }
    }

    void updateTransform() {
        if (this.fakeEntity == null) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        Quaternionf parentRotation = this.parent.getRotation();
        Quaternionf combinedRotation = new Quaternionf((Quaternionfc)parentRotation).mul((Quaternionfc)this.localRotation);
        Vector3f rotatedTranslation = parentRotation.transform(new Vector3f((Vector3fc)this.translationOffset));
        this.fakeEntity.setTranslation(rotatedTranslation);
        this.fakeEntity.setLeftRotation(combinedRotation);
        this.fakeEntity.setScale(new Vector3f((Vector3fc)this.localScale));
        this.fakeEntity.setRightRotation(new Quaternionf());
        Set<Player> viewers = this.parent.getViewers();
        if (!viewers.isEmpty()) {
            ArrayList<Player> onlineViewers = new ArrayList<Player>();
            for (Player viewer : viewers) {
                if (!viewer.isOnline()) continue;
                onlineViewers.add(viewer);
            }
            if (!onlineViewers.isEmpty()) {
                this.sendTo(onlineViewers);
            }
        }
    }

    Location calculateWorldPosition() {
        if (this.parent == null) {
            return this.location();
        }
        Location anchor = this.parent.getAnchor();
        Quaternionf parentRotation = this.parent.getRotation();
        Vector3f rotatedOffset = parentRotation.transform(new Vector3f((Vector3fc)this.relativeOffset));
        Location worldPos = anchor.clone().add((double)rotatedOffset.x, (double)rotatedOffset.y, (double)rotatedOffset.z);
        worldPos.setYaw(0.0f);
        worldPos.setPitch(0.0f);
        return worldPos;
    }

    private Location location() {
        return this.fakeEntity != null ? this.fakeEntity.getLocation() : null;
    }

    void spawnFor(Collection<? extends Player> players) {
        if (this.fakeEntity == null) {
            return;
        }
        this.updateTransform();
        Location pos = this.calculateWorldPosition();
        this.fakeEntity.teleport(pos, players);
        this.fakeEntity.spawn(players);
    }

    void spawnFor(Player player) {
        this.spawnFor(Collections.singleton(player));
    }

    void destroyFor(Collection<? extends Player> players) {
        if (this.fakeEntity == null) {
            return;
        }
        this.fakeEntity.destroy(players);
    }

    void destroyFor(Player player) {
        this.destroyFor(Collections.singleton(player));
    }

    void sendTo(Collection<? extends Player> players) {
        if (this.fakeEntity == null) {
            return;
        }
        Location pos = this.calculateWorldPosition();
        this.fakeEntity.teleport(pos, players);
        this.fakeEntity.sendMetadata(players);
    }

    void sendTo(Player player) {
        this.sendTo(Collections.singleton(player));
    }

    void remove() {
        this.fakeEntity = null;
    }

    public boolean isValid() {
        return this.fakeEntity != null;
    }

    public String toString() {
        return String.format("HoloElement{name='%s', type=%s, offset=(%.2f, %.2f, %.2f), scale=(%.2f, %.2f, %.2f)}", new Object[]{this.name, this.type, Float.valueOf(this.relativeOffset.x), Float.valueOf(this.relativeOffset.y), Float.valueOf(this.relativeOffset.z), Float.valueOf(this.localScale.x), Float.valueOf(this.localScale.y), Float.valueOf(this.localScale.z)});
    }

    public static enum Type {
        BLOCK_DISPLAY,
        ITEM_DISPLAY;

    }
}

