/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.syntax;

import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import cn.lunadeer.dominion.utils.databse.syntax.Syntax;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class Select
implements Syntax {
    protected final Field<?>[] columns;
    protected final String columnsString;
    protected String tableName;
    protected String where;
    protected Object[] whereArgs;
    protected String ascendingColumn;
    protected String descendingColumn;

    public static Select select(Field<?> ... columns) {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.SQLITE -> new sqlite_impl(columns);
            case DatabaseType.MYSQL -> new mysql_impl(columns);
            case DatabaseType.PGSQL -> new pgsql_impl(columns);
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported with SELECT");
        };
    }

    private Select(Field<?>[] columns) {
        this.columns = columns;
        this.columnsString = Arrays.stream(columns).map(Field::getName).reduce((a, b) -> a + ", " + b).orElse("*");
    }

    public Select from(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Select where(String conditions, Object ... args) {
        this.where = conditions;
        this.whereArgs = args;
        return this;
    }

    public Select where(String conditions) {
        this.where = conditions;
        return this;
    }

    public Select ascend(String column) {
        this.ascendingColumn = column;
        return this;
    }

    public Select descend(String column) {
        this.descendingColumn = column;
        return this;
    }

    public List<Map<String, Field<?>>> execute() throws SQLException {
        List<Map<String, Field<?>>> list;
        block12: {
            Connection conn = DatabaseManager.instance.getConnection();
            try {
                Object sql = this.getSql();
                if (this.ascendingColumn != null) {
                    sql = (String)sql + " ORDER BY " + this.ascendingColumn + " ASC";
                }
                if (this.descendingColumn != null) {
                    sql = (String)sql + " ORDER BY " + this.descendingColumn + " DESC";
                }
                PreparedStatement preparedStatement = conn.prepareStatement((String)sql);
                if (this.whereArgs != null) {
                    for (int i = 0; i < this.whereArgs.length; ++i) {
                        preparedStatement.setObject(i + 1, this.whereArgs[i]);
                    }
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                list = Field.getFromResultSet(this.columns, resultSet);
                if (conn == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    XLogger.error("SQL: " + this.getSql());
                    XLogger.error("WHERE Param: " + Arrays.toString(this.whereArgs));
                    XLogger.error(e);
                    throw new SQLException("Error executing query: " + e.getMessage());
                }
            }
            conn.close();
        }
        return list;
    }

    private static class sqlite_impl
    extends Select {
        public sqlite_impl(Field<?>[] columns) {
            super(columns);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append(this.columnsString);
            sql.append(" FROM ").append(this.tableName);
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            return sql.toString();
        }
    }

    private static class mysql_impl
    extends Select {
        public mysql_impl(Field<?>[] columns) {
            super(columns);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append(this.columnsString);
            sql.append(" FROM ").append(this.tableName);
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            return sql.toString();
        }
    }

    private static class pgsql_impl
    extends Select {
        public pgsql_impl(Field<?>[] columns) {
            super(columns);
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append(this.columnsString);
            sql.append(" FROM ").append(this.tableName);
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            return sql.toString();
        }
    }
}

