/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.syntax;

import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import cn.lunadeer.dominion.utils.databse.syntax.Select;
import cn.lunadeer.dominion.utils.databse.syntax.Syntax;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Insert
implements Syntax {
    protected String tableName;
    protected Field<?>[] fields;
    protected Field<?>[] returnFields;
    protected String[] onConflictFields;
    protected boolean onConflictDoUpdate = false;

    public static Insert insert() {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.PGSQL, DatabaseType.SQLITE -> new pgsql_sqlite_impl();
            case DatabaseType.MYSQL -> new mysql_impl();
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported with INSERT");
        };
    }

    private Insert() {
    }

    public Insert into(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Insert values(Field<?> ... fields) {
        this.fields = fields;
        return this;
    }

    public Insert onConflict(String ... fields) {
        this.onConflictFields = fields;
        return this;
    }

    public Insert doNothing() {
        this.onConflictDoUpdate = false;
        return this;
    }

    public Insert doUpdate() {
        this.onConflictDoUpdate = true;
        return this;
    }

    public Insert returning(Field<?> ... fields) {
        this.returnFields = fields;
        return this;
    }

    public abstract Map<String, Field<?>> execute() throws SQLException;

    @Override
    public String getSql() {
        int i;
        StringBuilder sql = new StringBuilder("INSERT INTO " + this.tableName + " (");
        for (i = 0; i < this.fields.length; ++i) {
            sql.append(this.fields[i].getName());
            if (i >= this.fields.length - 1) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (");
        for (i = 0; i < this.fields.length; ++i) {
            sql.append("?");
            if (i >= this.fields.length - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    private static class pgsql_sqlite_impl
    extends Insert {
        private pgsql_sqlite_impl() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<String, Field<?>> execute() throws SQLException {
            try (Connection connection = DatabaseManager.instance.getConnection();){
                Map<String, Field<?>> map;
                block21: {
                    PreparedStatement preparedStatement;
                    block19: {
                        Field[] fieldArray;
                        block20: {
                            preparedStatement = connection.prepareStatement(this.getSql());
                            try {
                                for (int i = 0; i < this.fields.length; ++i) {
                                    preparedStatement.setObject(i + 1, this.fields[i].getValue());
                                }
                                if (this.returnFields == null || this.returnFields.length <= 0) break block19;
                                ResultSet resultSet = preparedStatement.executeQuery();
                                Field[] result = new HashMap();
                                while (resultSet.next()) {
                                    for (Field field : this.returnFields) {
                                        result.put(field.getName(), Field.getFromResultSet(field, resultSet));
                                    }
                                }
                                fieldArray = result;
                                if (preparedStatement == null) break block20;
                            }
                            catch (Throwable throwable) {
                                if (preparedStatement != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            preparedStatement.close();
                        }
                        return fieldArray;
                    }
                    preparedStatement.executeUpdate();
                    map = Map.of();
                    if (preparedStatement == null) break block21;
                    preparedStatement.close();
                }
                return map;
            }
            catch (SQLException e) {
                XLogger.error("SQL: " + this.getSql());
                XLogger.error("Param: " + String.valueOf(Arrays.stream(this.fields).map(Field::getValue)));
                XLogger.error(e);
                throw new SQLException("Error executing delete statement: " + e.getMessage(), e);
            }
        }

        @Override
        public String getSql() {
            int i;
            StringBuilder sql = new StringBuilder(super.getSql());
            if (this.onConflictFields != null && this.onConflictFields.length > 0) {
                sql.append(" ON CONFLICT (");
                for (i = 0; i < this.onConflictFields.length; ++i) {
                    sql.append(this.onConflictFields[i]);
                    if (i >= this.onConflictFields.length - 1) continue;
                    sql.append(", ");
                }
                sql.append(") DO ");
                if (this.onConflictDoUpdate) {
                    sql.append("UPDATE SET ");
                    for (i = 0; i < this.fields.length; ++i) {
                        String fieldName = this.fields[i].getName();
                        if (Arrays.asList(this.onConflictFields).contains(fieldName)) continue;
                        sql.append(fieldName).append(" = EXCLUDED.").append(fieldName);
                        if (i >= this.fields.length - 1) continue;
                        sql.append(", ");
                    }
                } else {
                    sql.append("NOTHING");
                }
            }
            if (this.returnFields != null && this.returnFields.length > 0) {
                sql.append(" RETURNING ");
                for (i = 0; i < this.returnFields.length; ++i) {
                    sql.append(this.returnFields[i].getName());
                    if (i >= this.returnFields.length - 1) continue;
                    sql.append(", ");
                }
            }
            return sql.toString();
        }
    }

    private static class mysql_impl
    extends Insert {
        private mysql_impl() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<String, Field<?>> execute() throws SQLException {
            try (Connection connection = DatabaseManager.instance.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement(this.getSql());
                for (int i = 0; i < this.fields.length; ++i) {
                    preparedStatement.setObject(i + 1, this.fields[i].getValue());
                }
                preparedStatement.executeUpdate();
                if (this.returnFields != null && this.returnFields.length > 0) {
                    Statement statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery("SELECT LAST_INSERT_ID()");
                    int id = 0;
                    if (resultSet.next()) {
                        id = resultSet.getInt(1);
                    }
                    if (id == 0) {
                        Map<String, Field<?>> map = Map.of();
                        return map;
                    }
                    List<Map<String, Field<?>>> result = Select.select(this.returnFields).from(this.tableName).where("id = ?", id).execute();
                    if (result.isEmpty()) {
                        Map<String, Field<?>> map = Map.of();
                        return map;
                    }
                    Map<String, Field<?>> map = result.get(0);
                    return map;
                }
                Map<String, Field<?>> map = Map.of();
                return map;
            }
            catch (SQLException e) {
                XLogger.error("SQL: " + this.getSql());
                XLogger.error("Param: " + String.valueOf(Arrays.stream(this.fields).map(Field::getValue)));
                XLogger.error(e);
                throw new SQLException("Error executing delete statement: " + e.getMessage(), e);
            }
        }

        @Override
        public String getSql() {
            StringBuilder sql = new StringBuilder(super.getSql());
            if (this.onConflictFields != null && this.onConflictFields.length > 0) {
                if (this.onConflictDoUpdate) {
                    sql.append(" ON DUPLICATE KEY UPDATE ");
                    for (int i = 0; i < this.fields.length; ++i) {
                        String fieldName = this.fields[i].getName();
                        if (Arrays.asList(this.onConflictFields).contains(fieldName)) continue;
                        sql.append(fieldName).append(" = VALUES(").append(fieldName).append(")");
                        if (i >= this.fields.length - 1) continue;
                        sql.append(", ");
                    }
                } else {
                    sql.replace(0, 6, "INSERT IGNORE");
                }
            }
            return sql.toString();
        }
    }
}

