/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.command;

import cn.lunadeer.dominion.utils.command.Suggestion;
import java.util.List;
import java.util.Objects;

public class Argument {
    private final String name;
    private final boolean required;
    private Suggestion suggestion = null;
    private String value = "";

    public Argument copy() {
        Argument copy = new Argument(this.name, this.required, this.suggestion);
        copy.value = this.value;
        return copy;
    }

    public Argument(String name, boolean required) {
        this(name, required, null);
    }

    public Argument(String name, String defaultValue) {
        this(name, false, null);
        this.value = defaultValue;
    }

    public Argument(String name, boolean required, Suggestion suggestion) {
        this.name = name;
        this.required = required;
        this.suggestion = suggestion;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Suggestion getSuggestion() {
        return Objects.requireNonNullElseGet(this.suggestion, () -> (sender, preArguments) -> List.of(this.toString()));
    }

    public void setSuggestion(Suggestion suggestion) {
        this.suggestion = suggestion;
    }

    public String toString() {
        if (this.required) {
            return "<" + this.name + ">";
        }
        return "[" + this.name + "]";
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

