/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ArgumentParser {
    private final Map<String, String> arguments = new HashMap<String, String>();

    public ArgumentParser(String[] args) {
        for (String arg : args) {
            String[] split = arg.split("=");
            if (split.length != 2) continue;
            this.arguments.put(split[0], split[1]);
        }
    }

    @Nullable
    public String getVal(String key) {
        return this.arguments.get(key);
    }

    @NotNull
    public String getVal(String key, String def) {
        return this.arguments.getOrDefault(key, def);
    }

    public boolean hasKey(String key) {
        return this.arguments.containsKey(key);
    }

    public int getValInt(String key) throws NumberFormatException {
        return Integer.parseInt(this.arguments.get(key));
    }

    public boolean getValBool(String key) {
        return Boolean.parseBoolean(this.arguments.get(key));
    }

    public int getValInt(String key, int def) throws IllegalArgumentException {
        return this.arguments.containsKey(key) ? Integer.parseInt(this.arguments.get(key)) : def;
    }

    public boolean getValBool(String key, boolean def) throws IllegalArgumentException {
        return this.arguments.containsKey(key) ? Boolean.parseBoolean(this.arguments.get(key)) : def;
    }
}

