/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.group;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.inputters.RenameGroupInputter;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupManage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class GroupFlags
extends AbstractUI {
    public static SecondaryCommand flags = new SecondaryCommand("group_flags", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredGroupArgument(0), new CommandArguments.OptionalPageArgument()), Language.uiCommandsDescription.groupFlags){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupFlags.show(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String dominionName, String groupName, String pageStr) {
        new GroupFlags().displayByPreference(sender, dominionName, groupName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName, final String groupName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.groupSettingTuiText.button){

            @Override
            public void function(String page) {
                GroupFlags.show(sender, dominionName, groupName, page);
            }
        }.needPermission(Dominion.defaultPermission).setHoverText(TextUserInterface.groupSettingTuiText.description);
    }

    @Override
    protected void showTUI(Player player, String ... args) {
        DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(player, dominion);
        GroupDTO group = Converts.toGroupDTO(dominion, args[1]);
        int page = Converts.toIntegrity(args[2], 1);
        ListView view = ListView.create(10, GroupFlags.button((CommandSender)player, dominion.getName(), group.getNamePlain()));
        view.title(Misc.formatString(TextUserInterface.groupSettingTuiText.title, group.getNameColoredBukkit()));
        view.navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(DominionList.button((CommandSender)player).build()).append(DominionManage.button((CommandSender)player, dominion.getName()).build()).append(GroupList.button((CommandSender)player, dominion.getName()).build()).append(TextUserInterface.groupSettingTuiText.button));
        view.add(Line.create().append(RenameGroupInputter.createTuiButtonOn((CommandSender)player, dominion.getName(), group.getNamePlain()).build()));
        if (group.getFlagValue(Flags.ADMIN).booleanValue()) {
            view.add(GroupFlags.createOption(player, Flags.ADMIN, true, dominion.getName(), group.getNamePlain(), args[2]));
            view.add(GroupFlags.createOption(player, Flags.GLOW, group.getFlagValue(Flags.GLOW), dominion.getName(), group.getNamePlain(), args[2]));
        } else {
            for (PriFlag flag : Flags.getAllPriFlagsEnable()) {
                view.add(GroupFlags.createOption(player, flag, group.getFlagValue(flag), dominion.getName(), group.getNamePlain(), args[2]));
            }
        }
        view.showOn(player, page);
    }

    private static Line createOption(final Player player, final PriFlag flag, boolean value, final String DominionName, final String groupName, final String pageStr) {
        if (value) {
            return Line.create().append(new FunctionalButton("\u2611"){

                @Override
                public void function() {
                    GroupCommand.setGroupFlag((CommandSender)player, DominionName, groupName, flag.getFlagName(), "false", pageStr);
                }
            }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
        }
        return Line.create().append(new FunctionalButton("\u2610"){

            @Override
            public void function() {
                GroupCommand.setGroupFlag((CommandSender)player, DominionName, groupName, flag.getFlagName(), "true", pageStr);
            }
        }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
    }

    @Override
    protected void showCUI(final Player player, String ... args) {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(player, dominion);
        final GroupDTO group = Converts.toGroupDTO(dominion, args[1]);
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.groupSettingCui.title, group.getNameColoredBukkit()));
        view.applyListConfiguration(ChestUserInterface.groupSettingCui.listConfiguration, Converts.toIntegrity(args[2]));
        view.setButton(ChestUserInterface.groupSettingCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.groupSettingCui.backButton){

            @Override
            public void onClick(ClickType type) {
                GroupManage.show((CommandSender)player, dominion.getName(), group.getNamePlain(), "1");
            }
        });
        for (int i = 0; i < Flags.getAllPriFlagsEnable().size(); ++i) {
            final PriFlag flag = Flags.getAllPriFlagsEnable().get(i);
            final Integer page = (int)Math.ceil((double)(i + 1) / (double)view.getPageSize());
            String flagState = group.getFlagValue(flag) != false ? ChestUserInterface.groupSettingCui.flagItemStateTrue : ChestUserInterface.groupSettingCui.flagItemStateFalse;
            String flagName = Misc.formatString(ChestUserInterface.groupSettingCui.flagItemName, flag.getDisplayName());
            List<String> descriptions = Misc.foldLore2Line(flag.getDescription(), 30);
            List<String> flagLore = Misc.formatStringList(ChestUserInterface.groupSettingCui.flagItemLore, flagState, descriptions.get(0), descriptions.get(1));
            ButtonConfiguration btnConfig = ButtonConfiguration.createMaterial(ChestUserInterface.groupSettingCui.listConfiguration.itemSymbol.charAt(0), flag.getMaterial(), flagName, flagLore);
            view.addItem(new ChestButton(btnConfig){

                @Override
                public void onClick(ClickType type) {
                    GroupCommand.setGroupFlag((CommandSender)player, dominion.getName(), group.getNamePlain(), flag.getFlagName(), String.valueOf(group.getFlagValue(flag) == false), String.valueOf(page));
                }
            });
        }
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
        Notification.info(sender, ChestUserInterface.groupSettingCui.title);
        Notification.info(sender, GroupCommand.setGroupFlag.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, GroupCommand.setGroupFlag.getDescription());
        DominionDTO dominion = Converts.toDominionDTO(args[0]);
        GroupDTO group = Converts.toGroupDTO(dominion, args[1]);
        int page = Converts.toIntegrity(args[2], 1);
        Triple<Integer, Integer, Integer> pageInfo = Misc.pageUtil(page, 8, Flags.getAllPriFlagsEnable().size());
        for (int i = ((Integer)pageInfo.getLeft()).intValue(); i < (Integer)pageInfo.getMiddle(); ++i) {
            PriFlag flag = Flags.getAllPriFlagsEnable().get(i);
            String flagState = group.getFlagValue(flag) != false ? ChestUserInterface.groupSettingCui.flagItemStateTrue : ChestUserInterface.groupSettingCui.flagItemStateFalse;
            String flagName = Misc.formatString(ChestUserInterface.groupSettingCui.flagItemName, flag.getDisplayName());
            Notification.info(sender, "\u00a76\u25b6 {0} \u00a77(\u00a7b{1}\u00a77)", flagName, flag.getFlagName());
            Notification.info(sender, "\u00a76  \t{0}\t&7{1}", flagState, flag.getDescription());
        }
        Notification.info(sender, Language.consoleText.pageInfo, page, pageInfo.getRight(), Flags.getAllPriFlagsEnable().size());
    }

    public static class GroupSettingTuiText
    extends ConfigurationPart {
        public String title = "Group {0} Settings";
        public String description = "Manage the settings of group {0}.";
        public String button = "SETTING";
    }

    public static class GroupSettingCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a79\u00a7lGroup {0} Settings \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "Back", List.of("Go back to the", "guest manage."));
        public String flagItemName = "&7Flag: &9{0}";
        public String flagItemStateTrue = "&a&l[ENABLED]";
        public String flagItemStateFalse = "&c&l[DISABLED]";
        public List<String> flagItemLore = List.of("&7State: {0}", "&7Des: &f{1}", "       &f{2}", "", "&7Click to toggle this flag.");
    }
}

