/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.hooks;

import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Optional;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class WorldGuardHook {
    public static final StateFlag CLAIMING = new StateFlag("dominion-claim", false);

    public static boolean isConflict(@NotNull CuboidDTO cuboid, @NotNull World world) {
        Optional<RegionManager> regionManager = WorldGuardHook.getRegionManager(world);
        if (regionManager.isEmpty()) {
            return false;
        }
        ApplicableRegionSet set = WorldGuardHook.getOverlappingRegions(cuboid, regionManager.get(), world);
        return set.queryState(null, new StateFlag[]{CLAIMING}) == StateFlag.State.DENY;
    }

    @NotNull
    private static ApplicableRegionSet getOverlappingRegions(@NotNull CuboidDTO cuboid, @NotNull RegionManager manager, @NotNull World bukkitWorld) {
        return manager.getApplicableRegions((ProtectedRegion)new ProtectedCuboidRegion("dummy", BlockVector3.at((int)cuboid.x1(), (int)bukkitWorld.getMinHeight(), (int)cuboid.z1()), BlockVector3.at((int)cuboid.x2(), (int)bukkitWorld.getMaxHeight(), (int)cuboid.z2())));
    }

    private static Optional<RegionManager> getRegionManager(@NotNull World world) {
        return Optional.ofNullable(WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world)));
    }
}

